/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.codehaus.gmaven.feature.ComponentException;
import org.codehaus.gmaven.feature.Configuration;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.ComponentSupport;
import org.codehaus.gmaven.runtime.ClassFactory;
import org.codehaus.gmaven.runtime.ScriptExecutor;
import org.codehaus.gmaven.runtime.util.Callable;
import org.codehaus.gmaven.runtime.util.ClassSource;
import org.codehaus.gmaven.runtime.util.MagicAttribute;
import org.codehaus.gmaven.runtime.util.ResourceLoader;

public abstract class ScriptExecutorSupport
extends ComponentSupport
implements ScriptExecutor {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ScriptExecutorSupport(Feature feature, Configuration config) {
        super(feature, config);
    }

    protected ScriptExecutorSupport(Feature feature) {
        super(feature);
    }

    protected abstract ClassFactory getClassFactory();

    public Object execute(ClassSource source, ClassLoader classLoader, ResourceLoader resourceLoader, Configuration context) throws Exception {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        Class type = this.getClassFactory().create(source, classLoader, resourceLoader);
        Object target = type.newInstance();
        if (context != null) {
            this.applyContext(target, context);
        }
        return this.execute(target);
    }

    protected abstract Object createClosure(Callable var1);

    protected abstract Object createMagicAttribute(MagicAttribute var1);

    protected void applyContext(Object target, Configuration context) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        Method setter = this.lookupMethod(target.getClass(), "setProperty", new Class[]{String.class, Object.class});
        this.log.debug("Setting context:");
        Iterator iter = context.names().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = context.get(name);
            if (value instanceof Callable) {
                Callable c = (Callable)value;
                value = this.createClosure(c);
            } else if (value instanceof MagicAttribute) {
                MagicAttribute attr = (MagicAttribute)value;
                value = this.createMagicAttribute(attr);
            }
            if (this.log.isDebugEnabled()) {
                if (value != null) {
                    this.log.debug("    {} -> {} ({})", new Object[]{name, value, value.getClass()});
                } else {
                    this.log.debug("    {} -> {}", (Object)name, value);
                }
            }
            this.invokeMethod(target, setter, new Object[]{name, value});
        }
    }

    protected Object execute(Object target) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        Method run = this.lookupMethod(target.getClass(), "run", new Class[0]);
        return this.invokeMethod(target, run, new Object[0]);
    }

    protected Method lookupMethod(Class type, String name, Class[] sig) {
        Method method;
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sig == null) {
            throw new AssertionError();
        }
        try {
            method = type.getMethod(name, sig);
        }
        catch (Exception e) {
            throw new ComponentException("Failed to lookup method '" + name + "()' on: " + type, (Throwable)e);
        }
        return method;
    }

    protected Object invokeMethod(Object target, Method method, Object[] args) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && method == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Invoking {} on {} with {}", new Object[]{method, target, Arrays.asList(args)});
        }
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw new ComponentException(e.getTargetException());
        }
        catch (Exception e) {
            throw new ComponentException("Failed to invoke method '" + method + "' on target: " + target, (Throwable)e);
        }
    }

    static {
        $assertionsDisabled = !ScriptExecutorSupport.class.desiredAssertionStatus();
    }
}

