/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;

public class cStringIO {
    public static PyType InputType = PyType.fromClass(StringIO.class);
    public static PyType OutputType = PyType.fromClass(StringIO.class);
    private static String[] strings = new String[256];

    public static StringIO StringIO() {
        return new StringIO();
    }

    public static StringIO StringIO(String buffer) {
        return new StringIO(buffer);
    }

    static String getString(char ch) {
        if (ch > '\u00ff') {
            return new String(new char[]{ch});
        }
        String s = strings[ch];
        if (s == null) {
            cStringIO.strings[ch] = s = new String(new char[]{ch});
        }
        return s;
    }

    public static class StringIO
    extends PyIterator {
        public boolean softspace = false;
        public boolean closed = false;
        public int pos = 0;
        private final StringBuilder buf;

        public StringIO() {
            this.buf = new StringBuilder();
        }

        public StringIO(String buffer) {
            this.buf = new StringBuilder(buffer);
        }

        private void _complain_ifclosed() {
            if (this.closed) {
                throw Py.ValueError("I/O operation on closed file");
            }
        }

        private int _convert_to_int(long val) {
            if (val > Integer.MAX_VALUE) {
                throw Py.OverflowError("long int too large to convert to int");
            }
            return (int)val;
        }

        public void __setattr__(String name, PyObject value) {
            if (name == "softspace") {
                this.softspace = value.__nonzero__();
                return;
            }
            super.__setattr__(name, value);
        }

        public PyObject __iternext__() {
            this._complain_ifclosed();
            PyString r = this.readline();
            if (r.__len__() == 0) {
                return null;
            }
            return r;
        }

        public void close() {
            this.closed = true;
        }

        public boolean isatty() {
            this._complain_ifclosed();
            return false;
        }

        public void seek(long pos) {
            this.seek(pos, 0);
        }

        public synchronized void seek(long pos, int mode) {
            this._complain_ifclosed();
            switch (mode) {
                case 1: {
                    this.pos = (int)((long)this.pos + pos);
                    break;
                }
                case 2: {
                    this.pos = this._convert_to_int(pos + (long)this.buf.length());
                    break;
                }
                default: {
                    this.pos = this._convert_to_int(pos);
                }
            }
        }

        public synchronized void reset() {
            this.pos = 0;
        }

        public synchronized int tell() {
            this._complain_ifclosed();
            return this.pos;
        }

        public PyString read() {
            return this.read(-1L);
        }

        public synchronized PyString read(long size) {
            String substr;
            this._complain_ifclosed();
            this._convert_to_int(size);
            int len = this.buf.length();
            if (size < 0L) {
                substr = this.pos >= len ? "" : this.buf.substring(this.pos);
                this.pos = len;
            } else {
                int newpos = this._convert_to_int(Math.min((long)this.pos + size, (long)len));
                substr = this.buf.substring(this.pos, newpos);
                this.pos = newpos;
            }
            return new PyString(substr);
        }

        public PyString readline() {
            return this.readline(-1L);
        }

        public synchronized PyString readline(long size) {
            int newpos;
            this._complain_ifclosed();
            this._convert_to_int(size);
            int len = this.buf.length();
            if (this.pos == len) {
                return new PyString("");
            }
            int i = this.buf.indexOf("\n", this.pos);
            int n = newpos = i < 0 ? len : i + 1;
            if (size >= 0L) {
                newpos = this._convert_to_int(Math.min((long)(newpos - this.pos), size) + (long)this.pos);
            }
            String r = this.buf.substring(this.pos, newpos);
            this.pos = newpos;
            return new PyString(r);
        }

        public synchronized PyString readlineNoNl() {
            this._complain_ifclosed();
            int len = this.buf.length();
            int i = this.buf.indexOf("\n", this.pos);
            int newpos = i < 0 ? len : i;
            String r = this.buf.substring(this.pos, newpos);
            this.pos = newpos;
            if (this.pos < len) {
                ++this.pos;
            }
            return new PyString(r);
        }

        public PyObject readlines() {
            return this.readlines(0L);
        }

        public PyObject readlines(long sizehint) {
            this._complain_ifclosed();
            int sizehint_int = (int)sizehint;
            int total = 0;
            PyList lines = new PyList();
            PyString line = this.readline();
            while (line.__len__() > 0) {
                lines.append(line);
                if (0 < sizehint_int && sizehint_int <= (total += line.__len__())) break;
                line = this.readline();
            }
            return lines;
        }

        public void truncate() {
            this.truncate(-1L);
        }

        public synchronized void truncate(long pos) {
            int pos_int = this._convert_to_int(pos);
            if (pos_int < 0) {
                pos_int = this.pos;
            }
            this.buf.setLength(pos_int);
            this.pos = pos_int;
        }

        public void write(PyObject obj) {
            this.write(obj.toString());
        }

        public synchronized void write(String s) {
            this._complain_ifclosed();
            int spos = this.pos;
            int slen = this.buf.length();
            if (spos == slen) {
                this.buf.append(s);
                this.buf.setLength(slen + s.length());
                this.pos = spos + s.length();
                return;
            }
            if (spos > slen) {
                int l = spos - slen;
                char[] bytes = new char[l];
                for (int i = 0; i < l - 1; ++i) {
                    bytes[i] = '\u0000';
                }
                this.buf.append(bytes);
                slen = spos;
            }
            int newpos = spos + s.length();
            if (spos < slen) {
                if (newpos > slen) {
                    this.buf.replace(spos, slen - spos, s);
                    this.buf.append(s.substring(slen));
                    slen = newpos;
                } else {
                    this.buf.replace(spos, spos + s.length(), s);
                }
            } else {
                this.buf.append(s);
                slen = newpos;
            }
            this.buf.setLength(slen);
            this.pos = newpos;
        }

        public synchronized void writeChar(char ch) {
            int len = this.buf.length();
            if (len <= this.pos) {
                this.buf.setLength(this.pos + 1);
            }
            this.buf.setCharAt(this.pos++, ch);
        }

        public void writelines(PyObject lines) {
            for (PyObject line : lines.asIterable()) {
                this.write(line);
            }
        }

        public void flush() {
            this._complain_ifclosed();
        }

        public synchronized PyString getvalue() {
            this._complain_ifclosed();
            return new PyString(this.buf.toString());
        }
    }

    private static class os {
        public static final int SEEK_SET = 0;
        public static final int SEEK_CUR = 1;
        public static final int SEEK_END = 2;

        private os() {
        }
    }
}

