/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.v1_7;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.ComponentException;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.ComponentSupport;
import org.codehaus.gmaven.feature.support.FeatureSupport;
import org.codehaus.gmaven.runtime.ClassFactory;
import org.codehaus.gmaven.runtime.support.util.ResourceLoaderImpl;
import org.codehaus.gmaven.runtime.util.ClassSource;
import org.codehaus.gmaven.runtime.util.ResourceLoader;

public class ClassFactoryFeature
extends FeatureSupport {
    public ClassFactoryFeature() {
        super(ClassFactory.KEY);
    }

    protected Component doCreate() throws Exception {
        return new ClassFactoryImpl();
    }

    private class GroovyResourceLoaderAdapter
    implements GroovyResourceLoader {
        private final ResourceLoader loader;

        public GroovyResourceLoaderAdapter(ResourceLoader loader) {
            assert (loader != null);
            this.loader = loader;
        }

        public URL loadGroovySource(String name) throws MalformedURLException {
            return this.loader.loadResource(name);
        }
    }

    private class ClassFactoryImpl
    extends ComponentSupport
    implements ClassFactory {
        private ClassFactoryImpl() {
            super((Feature)ClassFactoryFeature.this);
        }

        public Class create(ClassSource classSource, ClassLoader classLoader, ResourceLoader resourceLoader) throws Exception {
            assert (classSource != null);
            assert (classLoader != null);
            GroovyClassLoader groovyClassLoader = this.createGroovyClassLoader(classLoader, resourceLoader);
            GroovyCodeSource codeSource = this.createGroovyCodeSource(classSource);
            return groovyClassLoader.parseClass(codeSource);
        }

        public Class create(ClassSource classSource, ClassLoader classLoader) throws Exception {
            return this.create(classSource, classLoader, null);
        }

        public Class create(String className, ClassLoader classLoader, ResourceLoader resourceLoader) throws Exception {
            URL source;
            assert (className != null);
            assert (classLoader != null);
            if (resourceLoader == null) {
                resourceLoader = new ResourceLoaderImpl(classLoader);
            }
            if ((source = resourceLoader.loadResource(className)) == null) {
                throw new ComponentException("Missing source for: " + className);
            }
            return this.create(new ClassSource(source), classLoader, resourceLoader);
        }

        public Class create(String className, ClassLoader classLoader) throws Exception {
            return this.create(className, classLoader, null);
        }

        private GroovyClassLoader createGroovyClassLoader(ClassLoader classLoader, ResourceLoader resourceLoader) {
            assert (classLoader != null);
            GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader);
            groovyClassLoader.setResourceLoader(this.createGroovyResourceLoader(classLoader, resourceLoader));
            return groovyClassLoader;
        }

        private GroovyResourceLoader createGroovyResourceLoader(ClassLoader classLoader, ResourceLoader resourceLoader) {
            assert (classLoader != null);
            if (resourceLoader == null) {
                resourceLoader = new ResourceLoaderImpl(classLoader);
            }
            return new GroovyResourceLoaderAdapter(resourceLoader);
        }

        private GroovyCodeSource createGroovyCodeSource(ClassSource source) throws IOException {
            assert (source != null);
            int count = 0;
            if (source.url != null) {
                ++count;
            }
            if (source.file != null) {
                ++count;
            }
            if (source.body != null) {
                ++count;
            }
            if (count == 0) {
                throw new ComponentException("Invalid class source; must define a URL, File or Body: " + source);
            }
            if (count != 1) {
                throw new ComponentException("Invalid class source; only one of URL, File or Body is allowed: " + source);
            }
            if (source.url != null) {
                return new GroovyCodeSource(source.url);
            }
            if (source.file != null) {
                return new GroovyCodeSource(source.file);
            }
            if (source.body != null) {
                return new GroovyCodeSource(source.body.input, source.body.name, source.body.codeBase);
            }
            throw new InternalError();
        }
    }
}

