/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.model.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.model.factory.GroovyModelFactory;
import ro.isdc.wro.extensions.model.factory.JsonModelFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.AbstractWroModelFactory;
import ro.isdc.wro.model.factory.LazyWroModelFactoryDecorator;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.util.LazyInitializer;

public class SmartWroModelFactory
extends AbstractWroModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SmartWroModelFactory.class);
    private static final String DEFAULT_WRO_FILE = "/src/main/webapp/WEB-INF/wro.xml";
    public static final String ALIAS = "smart";
    @Inject
    private Injector injector;
    private List<WroModelFactory> factoryList;
    private File wroFile;
    private boolean autoDetectWroFile = true;

    public static SmartWroModelFactory createFromStandaloneContext(StandaloneContext context) {
        Validate.notNull((Object)context);
        boolean autoDetectWroFile = FilenameUtils.normalize((String)context.getWroFile().getPath()).contains(FilenameUtils.normalize((String)DEFAULT_WRO_FILE));
        if (!autoDetectWroFile) {
            LOG.debug("autoDetect is " + autoDetectWroFile + " because wroFile: " + context.getWroFile() + " is not the same as the default one: " + DEFAULT_WRO_FILE);
        }
        return new SmartWroModelFactory().setWroFile(context.getWroFile()).setAutoDetectWroFile(autoDetectWroFile);
    }

    public SmartWroModelFactory setWroFile(File wroFile) {
        Validate.notNull((Object)wroFile);
        this.wroFile = wroFile;
        return this;
    }

    protected List<WroModelFactory> newWroModelFactoryFactoryList() {
        ArrayList<WroModelFactory> list = new ArrayList<WroModelFactory>();
        LOG.debug("auto detect wroFile: {}", (Object)this.autoDetectWroFile);
        list.add((WroModelFactory)this.newXmlModelFactory());
        list.add(this.newGroovyModelFactory());
        list.add(this.newJsonModelFactory());
        return list;
    }

    private XmlModelFactory newXmlModelFactory() {
        return new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() throws IOException {
                if (SmartWroModelFactory.this.wroFile == null) {
                    return super.getModelResourceAsStream();
                }
                return SmartWroModelFactory.this.createAutoDetectedStream(this.getDefaultModelFilename());
            }
        };
    }

    private WroModelFactory newGroovyModelFactory() {
        return new LazyWroModelFactoryDecorator((LazyInitializer)new LazyInitializer<WroModelFactory>(){

            protected WroModelFactory initialize() {
                GroovyModelFactory modelFactory = new GroovyModelFactory(){

                    protected InputStream getModelResourceAsStream() throws IOException {
                        if (SmartWroModelFactory.this.wroFile == null) {
                            return super.getModelResourceAsStream();
                        }
                        return SmartWroModelFactory.this.createAutoDetectedStream(this.getDefaultModelFilename());
                    }
                };
                SmartWroModelFactory.this.injector.inject((Object)modelFactory);
                return modelFactory;
            }
        });
    }

    private WroModelFactory newJsonModelFactory() {
        return new LazyWroModelFactoryDecorator((LazyInitializer)new LazyInitializer<WroModelFactory>(){

            protected WroModelFactory initialize() {
                JsonModelFactory modelFactory = new JsonModelFactory(){

                    protected InputStream getModelResourceAsStream() throws IOException {
                        if (SmartWroModelFactory.this.wroFile == null) {
                            return super.getModelResourceAsStream();
                        }
                        return SmartWroModelFactory.this.createAutoDetectedStream(this.getDefaultModelFilename());
                    }
                };
                SmartWroModelFactory.this.injector.inject((Object)modelFactory);
                return modelFactory;
            }
        });
    }

    private InputStream createAutoDetectedStream(String defaultFileName) throws IOException {
        try {
            Validate.notNull((Object)this.wroFile, (String)"Cannot call this method if wroFile is null!", (Object[])new Object[0]);
            if (this.autoDetectWroFile) {
                File file = new File(this.wroFile.getParentFile(), defaultFileName);
                LOG.debug("\tloading autodetected wro file: " + file);
                return new FileInputStream(file);
            }
            LOG.debug("loading wroFile: " + this.wroFile);
            return new FileInputStream(this.wroFile);
        }
        catch (FileNotFoundException e) {
            if (this.autoDetectWroFile) {
                throw e;
            }
            throw new WroRuntimeException("The wroFile doesn't exist. Skip trying with other wro model factories", (Throwable)e);
        }
    }

    public WroModel create() {
        if (this.factoryList == null) {
            this.factoryList = this.newWroModelFactoryFactoryList();
        }
        if (this.factoryList != null) {
            StringBuffer logMessageBuffer = new StringBuffer();
            for (WroModelFactory factory : this.factoryList) {
                try {
                    this.injector.inject((Object)factory);
                    Class<WroModelFactory> factoryClass = factory.getClass().asSubclass(WroModelFactory.class);
                    logMessageBuffer.append(" Using " + this.getClassName(factoryClass) + " for model creation..\n");
                    return (WroModel)factory.create();
                }
                catch (WroRuntimeException e) {
                    LOG.debug("[FAIL] creating model... will try another factory: {}", e.getCause());
                    logMessageBuffer.append("[FAIL] Model creation using " + this.getClassName(factory.getClass()) + " failed. Trying another ...\n");
                    logMessageBuffer.append("[FAIL] Exception occured while building the model using: " + this.getClassName(factory.getClass()) + " " + e.getMessage());
                    if (this.autoDetectWroFile || !(e.getCause() instanceof IOException)) continue;
                    throw e;
                }
            }
            LOG.error(logMessageBuffer.toString());
        }
        throw new WroRuntimeException("Cannot create model using any of provided factories");
    }

    protected String getClassName(Class<? extends WroModelFactory> factoryClass) {
        String className = factoryClass.isAnonymousClass() ? factoryClass.getSuperclass().getSimpleName() : factoryClass.getSimpleName();
        return className;
    }

    public SmartWroModelFactory setFactoryList(List<WroModelFactory> factoryList) {
        Validate.notNull(factoryList);
        this.factoryList = factoryList;
        return this;
    }

    public SmartWroModelFactory setAutoDetectWroFile(boolean autoDetectWroFile) {
        this.autoDetectWroFile = autoDetectWroFile;
        return this;
    }

    protected String getDefaultModelFilename() {
        return DEFAULT_WRO_FILE;
    }

    protected InputStream getModelResourceAsStream() throws IOException {
        throw new IllegalStateException("This method should never be called!");
    }
}

