/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS", "SE_TRANSIENT_FIELD_NOT_RESTORED"})
public final class FsMountPoint
implements Serializable,
Comparable<FsMountPoint> {
    private static final long serialVersionUID = 5723957985634276648L;
    public static final String SEPARATOR = "!/";
    private URI uri;
    @Nullable
    private transient FsPath path;
    @Nullable
    private volatile transient FsScheme scheme;
    @Nullable
    private volatile transient URI hierarchical;

    @Deprecated
    public static FsMountPoint create(String uri) {
        return FsMountPoint.create(uri, FsUriModifier.NULL);
    }

    @Deprecated
    public static FsMountPoint create(String uri, FsUriModifier modifier) {
        try {
            return new FsMountPoint(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FsMountPoint create(URI uri) {
        return FsMountPoint.create(uri, FsUriModifier.NULL);
    }

    public static FsMountPoint create(URI uri, FsUriModifier modifier) {
        try {
            return new FsMountPoint(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FsMountPoint create(FsScheme scheme, FsPath path) {
        try {
            return new FsMountPoint(scheme, path);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public FsMountPoint(String uri) throws URISyntaxException {
        this.parse(new URI(uri), FsUriModifier.NULL);
    }

    @Deprecated
    public FsMountPoint(String uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(new URI(uri), modifier);
    }

    public FsMountPoint(URI uri) throws URISyntaxException {
        this.parse(uri, FsUriModifier.NULL);
    }

    public FsMountPoint(URI uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(uri, modifier);
    }

    public FsMountPoint(FsScheme scheme, FsPath path) throws URISyntaxException {
        URI pu = path.toUri();
        if (!pu.isAbsolute()) {
            throw new QuotedUriSyntaxException(pu, "Path not absolute");
        }
        String penup = path.getEntryName().toUri().getPath();
        if (0 == penup.length()) {
            throw new QuotedUriSyntaxException(pu, "Empty entry name");
        }
        this.uri = new UriBuilder(true).scheme(scheme.toString()).path(pu.getScheme() + ':' + pu.getRawSchemeSpecificPart() + SEPARATOR).toUri();
        this.scheme = scheme;
        this.path = path;
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri, FsUriModifier modifier) throws URISyntaxException {
        if (null != (uri = modifier.modify(uri, FsUriModifier.PostFix.MOUNT_POINT)).getRawQuery()) {
            throw new QuotedUriSyntaxException(uri, "Query not allowed");
        }
        if (null != uri.getRawFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment not allowed");
        }
        if (uri.isOpaque()) {
            URI nuri;
            String ssp = uri.getRawSchemeSpecificPart();
            int i = ssp.lastIndexOf(SEPARATOR);
            if (ssp.length() - 2 != i) {
                throw new QuotedUriSyntaxException(uri, "Doesn't end with mount point separator \"!/\"");
            }
            this.path = new FsPath(new URI(ssp.substring(0, i)), modifier);
            URI pu = this.path.toUri();
            if (!pu.isAbsolute()) {
                throw new QuotedUriSyntaxException(uri, "Path not absolute");
            }
            if (0 == this.path.getEntryName().getPath().length()) {
                throw new QuotedUriSyntaxException(uri, "Empty URI path of entry name of path");
            }
            if (FsUriModifier.NULL != modifier && !uri.equals(nuri = new UriBuilder(true).scheme(uri.getScheme()).path(pu.getScheme() + ':' + pu.getRawSchemeSpecificPart() + SEPARATOR).toUri())) {
                uri = nuri;
            }
        } else {
            if (!uri.isAbsolute()) {
                throw new QuotedUriSyntaxException(uri, "Not absolute");
            }
            if (!uri.getRawPath().endsWith("/")) {
                throw new QuotedUriSyntaxException(uri, "URI path doesn't end with separator \"/\"");
            }
            this.path = null;
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (this.toUri().isAbsolute());
        assert (null == this.toUri().getRawQuery());
        assert (null == this.toUri().getRawFragment());
        if (this.toUri().isOpaque()) {
            assert (this.toUri().getRawSchemeSpecificPart().endsWith(SEPARATOR));
            assert (null != this.getPath());
            assert (this.getPath().toUri().isAbsolute());
            assert (null == this.getPath().toUri().getRawFragment());
            assert (0 != this.getPath().getEntryName().toUri().getRawPath().length());
        } else {
            assert (this.toUri().normalize() == this.toUri());
            assert (this.toUri().getRawPath().endsWith("/"));
            assert (null == this.getPath());
        }
        return true;
    }

    public URI toUri() {
        return this.uri;
    }

    @Deprecated
    public URI getUri() {
        return this.uri;
    }

    public URI toHierarchicalUri() {
        return null != this.hierarchical ? this.hierarchical : (this.hierarchical = this.uri.isOpaque() ? this.path.toHierarchicalUri() : this.uri);
    }

    @Deprecated
    public URI getHierarchicalUri() {
        return this.toHierarchicalUri();
    }

    public FsScheme getScheme() {
        return null != this.scheme ? this.scheme : (this.scheme = FsScheme.create(this.uri.getScheme()));
    }

    @Nullable
    public FsPath getPath() {
        return this.path;
    }

    @Nullable
    public FsMountPoint getParent() {
        assert (null == this.path || null != this.path.getMountPoint());
        return null == this.path ? null : this.path.getMountPoint();
    }

    public FsPath resolve(FsEntryName entryName) {
        return new FsPath(this, entryName);
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsMountPoint && this.uri.equals(((FsMountPoint)that).uri);
    }

    @Override
    public int compareTo(FsMountPoint that) {
        return this.uri.compareTo(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

