/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.SQLStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="MySQL store", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class MySQLStore
extends SQLStore {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLStore.class);
    private static final String RUN_ID_FIELD = "run_id";

    public MySQLStore() {
    }

    public MySQLStore(String url, String username, String password, String tablename) {
        super(url, username, password, tablename);
    }

    @Override
    public String createInsertIntoTableString(Event event) {
        String statementString = "insert into " + this.getTablename() + "(" + this.columnDefinitionsAsString() + ") values (" + this.makeQuestionMarks() + ");";
        return statementString;
    }

    @Override
    public String columnDefinitionsAsString() {
        String columnDefs;
        StringBuilder sb = new StringBuilder();
        if (!this.getPropertyTypeMap().keySet().isEmpty()) {
            for (String columnname : this.getOrderedKeys()) {
                sb.append("`");
                sb.append(columnname);
                sb.append("`, ");
            }
        }
        if ((columnDefs = sb.toString()).length() > 2) {
            columnDefs = columnDefs.substring(0, columnDefs.length() - 2);
        }
        return columnDefs;
    }

    @Override
    public String createColumnDefinitionsAsString() {
        String columnDefs;
        StringBuilder sb = new StringBuilder();
        if (!this.getPropertyTypeMap().keySet().isEmpty()) {
            for (String columnname : this.getOrderedKeys()) {
                sb.append("`");
                sb.append(columnname);
                sb.append("` ");
                sb.append(this.getPropertyTypeMap().get(columnname));
                sb.append(", ");
            }
        }
        if ((columnDefs = sb.toString()).length() > 2) {
            columnDefs = columnDefs.substring(0, columnDefs.length() - 2);
        }
        return "(" + columnDefs + ");";
    }

    static {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

