/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import java.io.Serializable;

public class TestRunId
implements Serializable {
    public static final char SEPARATOR = '/';
    public static final TestRunId ROOT = new TestRunId("");
    private final String testRunId;

    public TestRunId(String testRunId) {
        this.testRunId = testRunId;
    }

    public TestRunId(TestRunId parentTestRunId, TestRunId childTestRunId) {
        this(parentTestRunId.toString() + '/' + childTestRunId.toString());
    }

    public TestRunId getParent() {
        int lastIndex = this.testRunId.lastIndexOf(47);
        if (lastIndex < 0) {
            return ROOT;
        }
        return new TestRunId(this.testRunId.substring(0, lastIndex));
    }

    public boolean isRoot() {
        return ROOT.toString().equals(this.testRunId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRunId testRunId1 = (TestRunId)o;
        return this.testRunId.equals(testRunId1.testRunId);
    }

    public int hashCode() {
        return this.testRunId.hashCode();
    }

    public String toString() {
        return this.testRunId;
    }

    public boolean isSameOrChildOf(TestRunId runId) {
        return this.equals(runId) || !this.isRoot() && this.getParent().isSameOrChildOf(runId);
    }

    public TestRunId getTopLevel() {
        if (this.getParent().isRoot()) {
            return this;
        }
        return this.getParent().getTopLevel();
    }
}

