/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.webjars.MultipleMatchesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJarAssetLocator {
    public static final String WEBJARS_PACKAGE = "META-INF.resources.webjars";
    public static final String WEBJARS_PATH_PREFIX = "META-INF/resources/webjars";
    private static final int MAX_DIRECTORY_DEPTH = 5;
    final SortedMap<String, String> fullPathIndex;

    private static void aggregateFile(File file, Set<String> aggregatedChildren, Pattern filterExpr) {
        String path = file.getPath();
        String relativePath = path.substring(path.indexOf(WEBJARS_PATH_PREFIX));
        if (filterExpr.matcher(relativePath).matches()) {
            aggregatedChildren.add(relativePath);
        }
    }

    private static Set<String> listFiles(File file, Pattern filterExpr) {
        HashSet<String> aggregatedChildren = new HashSet<String>();
        WebJarAssetLocator.aggregateChildren(file, file, aggregatedChildren, filterExpr, 0);
        return aggregatedChildren;
    }

    private static void aggregateChildren(File rootDirectory, File file, Set<String> aggregatedChildren, Pattern filterExpr, int level) {
        if (file.isDirectory()) {
            if (level > 5) {
                throw new IllegalStateException("Got deeper than 5 levels while searching " + rootDirectory);
            }
            for (File child : file.listFiles()) {
                WebJarAssetLocator.aggregateChildren(rootDirectory, child, aggregatedChildren, filterExpr, level + 1);
            }
        } else {
            WebJarAssetLocator.aggregateFile(file, aggregatedChildren, filterExpr);
        }
    }

    private static Set<URL> listWebjarsParentURLs(ClassLoader[] classLoaders) {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader classLoader : classLoaders) {
            try {
                Enumeration<URL> enumeration = classLoader.getResources(WEBJARS_PATH_PREFIX);
                while (enumeration.hasMoreElements()) {
                    urls.add(enumeration.nextElement());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    private static Set<String> getAssetPaths(Pattern filterExpr, ClassLoader ... classLoaders) {
        HashSet<String> assetPaths = new HashSet<String>();
        Set<URL> urls = WebJarAssetLocator.listWebjarsParentURLs(classLoaders);
        for (URL url : urls) {
            JarFile jarFile;
            if ("file".equals(url.getProtocol())) {
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                Set<String> paths = WebJarAssetLocator.listFiles(file, filterExpr);
                assetPaths.addAll(paths);
                continue;
            }
            if (!"jar".equals(url.getProtocol())) continue;
            try {
                String path = url.getPath();
                File file = new File(URI.create(path.substring(0, path.indexOf("!"))));
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String assetPathCandidate = entry.getName();
                if (entry.isDirectory() || !filterExpr.matcher(assetPathCandidate).matches()) continue;
                assetPaths.add(assetPathCandidate);
            }
        }
        return assetPaths;
    }

    public static SortedMap<String, String> getFullPathIndex(Pattern filterExpr, ClassLoader ... classLoaders) {
        Set<String> assetPaths = WebJarAssetLocator.getAssetPaths(filterExpr, classLoaders);
        TreeMap<String, String> assetPathIndex = new TreeMap<String, String>();
        for (String assetPath : assetPaths) {
            assetPathIndex.put(WebJarAssetLocator.reversePath(assetPath), assetPath);
        }
        return assetPathIndex;
    }

    private static String reversePath(String assetPath) {
        String[] assetPathComponents = assetPath.split("/");
        StringBuilder reversedAssetPath = new StringBuilder();
        for (int i = assetPathComponents.length - 1; i >= 0; --i) {
            if (reversedAssetPath.length() > 0) {
                reversedAssetPath.append('/');
            }
            reversedAssetPath.append(assetPathComponents[i]);
        }
        return reversedAssetPath.toString();
    }

    public WebJarAssetLocator() {
        this(WebJarAssetLocator.getFullPathIndex(Pattern.compile(".*"), WebJarAssetLocator.class.getClassLoader()));
    }

    public WebJarAssetLocator(SortedMap<String, String> fullPathIndex) {
        this.fullPathIndex = fullPathIndex;
    }

    private String throwNotFoundException(String partialPath) {
        throw new IllegalArgumentException(partialPath + " could not be found. Make sure you've added the corresponding WebJar and please check for typos.");
    }

    public String getFullPath(String partialPath) {
        Iterator<Map.Entry<String, String>> fullPathTailIter;
        Map.Entry<String, String> fullPathEntry;
        String reversePartialPath = WebJarAssetLocator.reversePath(partialPath);
        SortedMap<String, String> fullPathTail = this.fullPathIndex.tailMap(reversePartialPath);
        if (fullPathTail.size() == 0) {
            this.throwNotFoundException(partialPath);
        }
        if (!(fullPathEntry = (fullPathTailIter = fullPathTail.entrySet().iterator()).next()).getKey().startsWith(reversePartialPath)) {
            this.throwNotFoundException(partialPath);
        }
        String fullPath = fullPathEntry.getValue();
        if (fullPathTailIter.hasNext() && fullPathTailIter.next().getKey().startsWith(reversePartialPath)) {
            throw new MultipleMatchesException("Multiple matches found for " + partialPath + ". Please provide a more specific path, for example by including a version number.");
        }
        return fullPath;
    }

    public SortedMap<String, String> getFullPathIndex() {
        return this.fullPathIndex;
    }

    public Set<String> listAssets(String folderPath) {
        Collection<String> allAssets = this.fullPathIndex.values();
        HashSet<String> assets = new HashSet<String>();
        String prefix = WEBJARS_PATH_PREFIX + folderPath;
        for (String asset : allAssets) {
            if (!asset.startsWith(prefix)) continue;
            assets.add(asset);
        }
        return assets;
    }
}

