/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractFunction;
import com.github.sommeri.less4j.core.compiler.expressions.strings.StringFormatter;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Format
extends AbstractFunction {
    Format() {
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression format;
        if (parameters.isEmpty()) {
            problemsHandler.errFormatWrongFirstParameter(call.getParameter());
        }
        if ((format = parameters.get(0)).getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)format, parameters.subList(1, parameters.size()), call.getUnderlyingStructure());
        }
        if (format.getType() == ASTCssNodeType.ESCAPED_VALUE) {
            return this.evaluate((EscapedValue)format, parameters.subList(1, parameters.size()), call.getUnderlyingStructure());
        }
        if (!format.isFaulty()) {
            problemsHandler.errFormatWrongFirstParameter(call.getParameter());
        }
        return new FaultyExpression(call);
    }

    private Expression evaluate(EscapedValue format, List<Expression> parameters, HiddenTokenAwareTree technicalUnderlying) {
        String newValue = this.format(format.getValue(), parameters, technicalUnderlying);
        return new CssString(format.getUnderlyingStructure(), newValue, "\"");
    }

    private Expression evaluate(CssString format, List<Expression> parameters, HiddenTokenAwareTree technicalUnderlying) {
        String newValue = this.format(format.getValue(), parameters, technicalUnderlying);
        return new CssString(format.getUnderlyingStructure(), newValue, "\"");
    }

    private String format(String value, List<Expression> parameters, HiddenTokenAwareTree technicalUnderlying) {
        StringFormatter formatter = new StringFormatter();
        return formatter.replaceIn(value, parameters.iterator(), technicalUnderlying);
    }
}

