/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FileUtils;

public class ReadmeExample {
    public static void main(String[] args) throws Less4jException {
        ReadmeExample.basicFileExample();
        ReadmeExample.customCssLocationExample1();
        ReadmeExample.customCssLocationExample2();
        ReadmeExample.guessedCssLocationExample1();
        ReadmeExample.guessedCssLocationExample2();
    }

    private static void basicFileExample() throws Less4jException {
        File inputLessFile = ReadmeExample.createFile("sampleInput.less", "* { margin: 1 1 1 1; }");
        ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
        LessCompiler.CompilationResult compilationResult = compiler.compile(inputLessFile);
        System.out.println(compilationResult.getCss());
        for (LessCompiler.Problem warning : compilationResult.getWarnings()) {
            System.err.println(ReadmeExample.format(warning));
        }
        ReadmeExample.deleteFile(inputLessFile);
    }

    private static void guessedCssLocationExample1() throws Less4jException {
        File inputLessFile = ReadmeExample.createFile("src/sampleInput.less", ".class { margin: 1 1 1 1; }");
        File lessFile = new File("src/sampleInput.less").getAbsoluteFile();
        DefaultLessCompiler compiler = new DefaultLessCompiler();
        LessCompiler.CompilationResult compilationResult = compiler.compile(lessFile);
        System.out.println(compilationResult.getCss());
        System.out.println(compilationResult.getSourceMap());
        ReadmeExample.deleteFile(inputLessFile);
    }

    private static void guessedCssLocationExample2() throws Less4jException {
        URI uri = new File("src/sampleInput.less").toURI();
        LessSource.StringSource lessSource = new LessSource.StringSource(".class { margin: 1 1 1 1; }", "sampleInput.less", uri);
        DefaultLessCompiler compiler = new DefaultLessCompiler();
        LessCompiler.CompilationResult compilationResult = compiler.compile(lessSource);
        System.out.println(compilationResult.getCss());
        System.out.println(compilationResult.getSourceMap());
    }

    private static void customCssLocationExample1() throws Less4jException {
        File inputLessFile = ReadmeExample.createFile("src/sampleInput.less", ".class { margin: 1 1 1 1; }");
        File lessFile = new File("src/sampleInput.less").getAbsoluteFile();
        File cssFile = new File("dist/sampleInput.css").getAbsoluteFile();
        LessCompiler.Configuration configuration = new LessCompiler.Configuration();
        configuration.setCssResultLocation(cssFile);
        DefaultLessCompiler compiler = new DefaultLessCompiler();
        LessCompiler.CompilationResult compilationResult = compiler.compile(lessFile, configuration);
        System.out.println(compilationResult.getCss());
        System.out.println(compilationResult.getSourceMap());
        ReadmeExample.deleteFile(inputLessFile);
    }

    private static void customCssLocationExample2() throws Less4jException {
        File cssFile = new File("dist/sampleInput.css").getAbsoluteFile();
        LessCompiler.Configuration configuration = new LessCompiler.Configuration();
        configuration.setCssResultLocation(cssFile);
        URI uri = new File("src/sampleInput.less").toURI();
        LessSource.StringSource lessSource = new LessSource.StringSource(".class { margin: 1 1 1 1; }", "sampleInput.less", uri);
        DefaultLessCompiler compiler = new DefaultLessCompiler();
        LessCompiler.CompilationResult compilationResult = compiler.compile(lessSource, configuration);
        System.out.println(compilationResult.getCss());
        System.out.println(compilationResult.getSourceMap());
    }

    private static void deleteFile(File inputLessFile) {
        try {
            FileUtils.forceDelete((File)inputLessFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File createFile(String filename, String content) {
        File file = new File(filename);
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    private static String format(LessCompiler.Problem warning) {
        return "WARNING " + warning.getLine() + ":" + warning.getCharacter() + " " + warning.getMessage();
    }
}

