/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.NullOverthereExecutionOutputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPUploadClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshScpFile
extends SshFile<SshScpConnection> {
    private static final Predicate<String> NOT_SELF_OR_PARENT_DIR = Predicates.not((Predicate)Predicates.or((Predicate)Predicates.equalTo((Object)"."), (Predicate)Predicates.equalTo((Object)"..")));
    private static final String PERMISSIONS_TOKEN_PATTERN = "[dl\\-]([r\\-][w\\-][xst\\-]){3}[@\\.\\+]*";
    private static Pattern permissionsTokenPattern = Pattern.compile("[dl\\-]([r\\-][w\\-][xst\\-]){3}[@\\.\\+]*");
    private static Logger logger = LoggerFactory.getLogger(SshScpFile.class);

    public SshScpFile(SshScpConnection connection, String remotePath) {
        super(connection, remotePath);
    }

    @Override
    public boolean exists() {
        return this.getFileInfo().exists;
    }

    @Override
    public boolean canRead() {
        return this.getFileInfo().canRead;
    }

    @Override
    public boolean canWrite() {
        return this.getFileInfo().canWrite;
    }

    @Override
    public boolean canExecute() {
        return this.getFileInfo().canExecute;
    }

    @Override
    public boolean isFile() {
        return this.getFileInfo().isFile;
    }

    @Override
    public boolean isDirectory() {
        return this.getFileInfo().isDirectory;
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        return this.getFileInfo().length;
    }

    public LsResults getFileInfo() throws RuntimeIOException {
        logger.debug("Retrieving file info of {}", (Object)this);
        CmdLine lsCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshScpConnection)this.connection).getFileInfoCommand, this.getPath());
        LsResults results = new LsResults();
        CapturingOverthereExecutionOutputHandler capturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int errno = this.executeCommand(capturedOutput, NullOverthereExecutionOutputHandler.swallow(), lsCmdLine);
        if (errno == 0) {
            for (int i = capturedOutput.getOutputLines().size() - 1; i >= 0; --i) {
                if (!this.parseLsOutputLine(results, capturedOutput.getOutputLines().get(i))) continue;
                results.exists = true;
                break;
            }
            if (!results.exists) {
                throw new RuntimeIOException("ls -ld " + this.getPath() + " returned " + errno + " but its output is unparseable: " + capturedOutput.getOutput());
            }
        } else {
            results.exists = false;
        }
        logger.debug("Listed file {}: exists={}, isDirectory={}, length={}, canRead={}, canWrite={}, canExecute={}", new Object[]{this, results.exists, results.isDirectory, results.length, results.canRead, results.canWrite, results.canExecute});
        return results;
    }

    protected boolean parseLsOutputLine(LsResults results, String outputLine) {
        StringTokenizer outputTokens = new StringTokenizer(outputLine);
        if (outputTokens.countTokens() < 5) {
            logger.debug("Not parsing ls output line [{}] because it has less than 5 tokens", (Object)outputLine);
            return false;
        }
        String permissions = outputTokens.nextToken();
        if (!permissionsTokenPattern.matcher(permissions).matches()) {
            logger.debug("Not parsing ls output line [{}] because it the first token does not match the pattern for permissions [[dl\\-]([r\\-][w\\-][xst\\-]){3}[@\\.\\+]*]", (Object)outputLine);
            return false;
        }
        logger.debug("Parsing ls output line [{}]", (Object)outputLine);
        outputTokens.nextToken();
        outputTokens.nextToken();
        outputTokens.nextToken();
        String size = outputTokens.nextToken();
        results.isFile = permissions.length() >= 1 && permissions.charAt(0) == '-';
        results.isDirectory = permissions.length() >= 1 && permissions.charAt(0) == 'd';
        results.canRead = permissions.length() >= 2 && permissions.charAt(1) == 'r';
        results.canWrite = permissions.length() >= 3 && permissions.charAt(2) == 'w';
        results.canExecute = permissions.length() >= 4 && permissions.charAt(3) == 'x';
        try {
            results.length = Integer.parseInt(size);
        }
        catch (NumberFormatException exc) {
            logger.warn("Cannot parse length of " + this.getPath() + " from ls output: " + outputLine + ". Length will be reported as -1.", (Throwable)exc);
        }
        return true;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        try {
            final File tempFile = File.createTempFile("scp_download", ".tmp");
            tempFile.deleteOnExit();
            logger.debug("Downloading contents of {} to temporary file {}", (Object)this, (Object)tempFile);
            ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().download(this.getPath(), tempFile.getPath());
            logger.debug("Opening input stream to temporary file {} to retrieve contents downloaded from {}. Temporary file will be deleted when the stream is closed", (Object)tempFile, (Object)this);
            return new FileInputStream(tempFile){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    logger.debug("Closing input stream to temporary file {}", (Object)tempFile);
                    try {
                        super.close();
                    }
                    finally {
                        logger.debug("Deleting temporary file {}", (Object)tempFile);
                        tempFile.delete();
                    }
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException(String.format("Cannot open %s for reading: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        try {
            final File tempFile = File.createTempFile("scp_upload", ".tmp");
            tempFile.deleteOnExit();
            logger.debug("Opening output stream to temporary file {} to store contents to be uploaded to {} when the stream is closed", (Object)tempFile, (Object)this);
            return new FileOutputStream(tempFile){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    logger.debug("Closing output stream to temporary file {}", (Object)tempFile);
                    try {
                        super.close();
                    }
                    finally {
                        this.uploadAndDelete(tempFile);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void uploadAndDelete(File tempFile2) throws IOException {
                    logger.debug("Uploading contents of temporary file {} to to {}", (Object)tempFile2, (Object)SshScpFile.this);
                    try {
                        ((SshScpConnection)SshScpFile.this.connection).getSshClient().newSCPFileTransfer().upload(tempFile2.getPath(), SshScpFile.this.getPath());
                    }
                    finally {
                        logger.debug("Deleting temporary file {}", (Object)tempFile2);
                        tempFile2.delete();
                    }
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException(String.format("Cannot open %s for writing: %s", this, exc.toString()), exc);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        logger.debug("Listing directory {}", (Object)this);
        CmdLine lsCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshScpConnection)this.connection).listFilesCommand, this.getPath());
        CapturingOverthereExecutionOutputHandler capturedStdout = CapturingOverthereExecutionOutputHandler.capturingHandler();
        CapturingOverthereExecutionOutputHandler capturedStderr = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), capturedStdout), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), capturedStderr), lsCmdLine);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + capturedStderr.getOutput() + " (errno=" + errno + ")");
        }
        ArrayList files = Lists.newArrayList();
        for (String lsLine : capturedStdout.getOutputLines()) {
            if (!NOT_SELF_OR_PARENT_DIR.apply((Object)lsLine)) continue;
            files.add(((SshScpConnection)this.connection).getFile(this, lsLine));
        }
        return files;
    }

    @Override
    public void mkdir() {
        logger.debug("Creating directory {}", (Object)this);
        this.mkdir(((SshScpConnection)this.connection).mkdirCommand);
    }

    @Override
    public void mkdirs() {
        logger.debug("Creating directories {}", (Object)this);
        this.mkdir(((SshScpConnection)this.connection).mkdirsCommand);
    }

    protected void mkdir(String command) throws RuntimeIOException {
        CmdLine mkdirCmdLine = CmdLine.build("nocd").addTemplatedFragment(command, this.getPath());
        this.executeAndThrowOnErrorCode(mkdirCmdLine, "Cannot create directory or -ies " + this);
        if (logger.isDebugEnabled()) {
            logger.debug("Created directory " + this + " (using command: " + command + ")");
        }
    }

    @Override
    public void renameTo(OverthereFile dest) {
        SshScpFile sshScpDestFile;
        logger.debug("Renaming {} to {}", (Object)this, (Object)dest);
        if (dest instanceof SshScpFile) {
            sshScpDestFile = (SshScpFile)dest;
            if (sshScpDestFile.getConnection() != this.getConnection()) {
                throw new RuntimeIOException("Cannot rename :ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to file/directory " + dest + " because it is in a different connection");
            }
        } else {
            throw new RuntimeIOException("Cannot rename :ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-:ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + dest);
        }
        CmdLine mvCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshScpConnection)this.connection).renameToCommand, this.getPath(), sshScpDestFile.getPath());
        this.executeAndThrowOnErrorCode(mvCmdLine, "Cannot rename file/directory " + this);
    }

    @Override
    public void setExecutable(boolean executable) {
        logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)executable);
        CmdLine chmodCmdLine = CmdLine.build("nocd").addTemplatedFragment(executable ? ((SshScpConnection)this.connection).setExecutableCommand : ((SshScpConnection)this.connection).setNotExecutableCommand, this.getPath());
        this.executeAndThrowOnErrorCode(chmodCmdLine, "Cannot set execute permission on file " + this + " to " + executable);
    }

    @Override
    protected void deleteDirectory() {
        logger.debug("Deleting directory {}", (Object)this);
        CmdLine rmdirCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshScpConnection)this.connection).deleteDirectoryCommand, this.getPath());
        this.executeAndThrowOnErrorCode(rmdirCmdLine, "Cannot delete directory " + this);
    }

    @Override
    protected void deleteFile() {
        logger.debug("Deleting file {}", (Object)this);
        CmdLine rmCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshScpConnection)this.connection).deleteFileCommand, this.getPath());
        this.executeAndThrowOnErrorCode(rmCmdLine, "Cannot delete file " + this);
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        logger.debug("Recursively deleting file or directory {}", (Object)this);
        CmdLine rmCmdLine = CmdLine.build("nocd").addTemplatedFragment(((SshScpConnection)this.connection).deleteRecursivelyCommand, this.getPath());
        this.executeAndThrowOnErrorCode(rmCmdLine, "Cannot recursively delete file or directory " + this);
    }

    @Override
    protected void copyFrom(OverthereFile source) {
        logger.debug("Copying file or directory {} to {}", (Object)source, (Object)this);
        SCPUploadClient uploadClient = ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient();
        try {
            if (source.isDirectory() && this.exists()) {
                for (OverthereFile sourceFile : source.listFiles()) {
                    uploadClient.copy((LocalSourceFile)new OverthereFileLocalSourceFile(sourceFile), this.getPath());
                }
            } else {
                uploadClient.copy((LocalSourceFile)new OverthereFileLocalSourceFile(source), this.getPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot copy " + source + " to " + this + ": " + e.toString(), e);
        }
    }

    private void executeAndThrowOnErrorCode(CmdLine mkdirCmdLine, String message) {
        CapturingOverthereExecutionOutputHandler capturedStderr = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int errno = this.executeCommand(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), capturedStderr), mkdirCmdLine);
        if (errno != 0) {
            throw new RuntimeIOException(String.format("%s: %s (errno=%d)", message, capturedStderr.getOutput(), errno));
        }
    }

    protected static class OverthereFileLocalSourceFile
    implements LocalSourceFile {
        private OverthereFile f;

        public OverthereFileLocalSourceFile(OverthereFile f) {
            this.f = f;
        }

        public String getName() {
            return this.f.getName();
        }

        public long getLength() {
            return this.f.length();
        }

        public InputStream getInputStream() throws IOException {
            return this.f.getInputStream();
        }

        public int getPermissions() throws IOException {
            return this.f.isDirectory() ? 493 : 420;
        }

        public boolean isFile() {
            return this.f.isFile();
        }

        public boolean isDirectory() {
            return this.f.isDirectory();
        }

        public Iterable<? extends LocalSourceFile> getChildren(LocalFileFilter filter) throws IOException {
            ArrayList files = Lists.newArrayList();
            for (OverthereFile each : this.f.listFiles()) {
                files.add(new OverthereFileLocalSourceFile(each));
            }
            return files;
        }

        public boolean providesAtimeMtime() {
            return false;
        }

        public long getLastAccessTime() throws IOException {
            return 0L;
        }

        public long getLastModifiedTime() throws IOException {
            return 0L;
        }
    }

    public static class LsResults {
        public boolean exists;
        public boolean isFile;
        public boolean isDirectory;
        public long length = -1L;
        public boolean canRead;
        public boolean canWrite;
        public boolean canExecute;
    }
}

