@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  server startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

@rem Add default JVM options here. You can also use JAVA_OPTS and SERVER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windowz variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\server-0.2.0.jar;%APP_HOME%\lib\jetty-webapp-9.1.2.v20140210.jar;%APP_HOME%\lib\jetty-server-9.1.2.v20140210.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\jetty-servlet-9.1.2.v20140210.jar;%APP_HOME%\lib\jetty-util-9.1.2.v20140210.jar;%APP_HOME%\lib\resteasy-jaxrs-2.3.5.Final.jar;%APP_HOME%\lib\resteasy-spring-2.3.5.Final.jar;%APP_HOME%\lib\jaxrs-api-2.3.5.Final.jar;%APP_HOME%\lib\resteasy-jaxb-provider-2.3.5.Final.jar;%APP_HOME%\lib\resteasy-jettison-provider-2.3.5.Final.jar;%APP_HOME%\lib\jettison-1.3.1.jar;%APP_HOME%\lib\cglib-2.2.2.jar;%APP_HOME%\lib\spring-web-3.1.4.RELEASE.jar;%APP_HOME%\lib\spring-core-3.1.4.RELEASE.jar;%APP_HOME%\lib\spring-context-3.1.4.RELEASE.jar;%APP_HOME%\lib\spring-beans-3.1.4.RELEASE.jar;%APP_HOME%\lib\jython-standalone-2.5.3.jar;%APP_HOME%\lib\udm-plugin-api-2014.2.jar;%APP_HOME%\lib\engine-api-2014.2.jar;%APP_HOME%\lib\engine-spi-2014.2.jar;%APP_HOME%\lib\local-booter-2014.2.jar;%APP_HOME%\lib\par-tasker-2014.2.jar;%APP_HOME%\lib\overthere-2.4.3.jar;%APP_HOME%\lib\guava-16.0.1.jar;%APP_HOME%\lib\appserver-api-impl-2014.2.jar;%APP_HOME%\lib\appserver-core-2014.2.jar;%APP_HOME%\lib\engine-xml-2014.2.jar;%APP_HOME%\lib\freemarker-2.3.19.jar;%APP_HOME%\lib\json-path-0.8.1.jar;%APP_HOME%\lib\json-smart-1.1.1.jar;%APP_HOME%\lib\httpclient-4.3.3.jar;%APP_HOME%\lib\httpcore-4.3.2.jar;%APP_HOME%\lib\scala-library-2.10.3.jar;%APP_HOME%\lib\jcr-2.0.jar;%APP_HOME%\lib\lesscss-1.3.3.jar;%APP_HOME%\lib\wro4j-core-1.7.2.jar;%APP_HOME%\lib\wro4j-extensions-1.7.2.jar;%APP_HOME%\lib\jetty-xml-9.1.2.v20140210.jar;%APP_HOME%\lib\jetty-http-9.1.2.v20140210.jar;%APP_HOME%\lib\jetty-io-9.1.2.v20140210.jar;%APP_HOME%\lib\jetty-security-9.1.2.v20140210.jar;%APP_HOME%\lib\scannotation-1.0.3.jar;%APP_HOME%\lib\jsr250-api-1.0.jar;%APP_HOME%\lib\activation-1.1.jar;%APP_HOME%\lib\commons-httpclient-3.1.jar;%APP_HOME%\lib\jcip-annotations-1.0.jar;%APP_HOME%\lib\jaxb-impl-2.2.4.jar;%APP_HOME%\lib\asm-3.3.1.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\spring-aop-3.1.4.RELEASE.jar;%APP_HOME%\lib\spring-asm-3.1.4.RELEASE.jar;%APP_HOME%\lib\spring-expression-3.1.4.RELEASE.jar;%APP_HOME%\lib\log4j-over-slf4j-1.7.2.jar;%APP_HOME%\lib\logback-classic-1.1.2.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.2.jar;%APP_HOME%\lib\xstream-1.4.4.jar;%APP_HOME%\lib\resteasy-multipart-provider-2.3.5.Final.jar;%APP_HOME%\lib\scannit-1.2.1.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\javassist-3.17.1-GA.jar;%APP_HOME%\lib\akka-slf4j_2.10-2.2.3.jar;%APP_HOME%\lib\grizzled-slf4j_2.10-1.0.1.jar;%APP_HOME%\lib\akka-actor_2.10-2.2.3.jar;%APP_HOME%\lib\scala-reflect-2.10.3.jar;%APP_HOME%\lib\nscala-time_2.10-0.6.0.jar;%APP_HOME%\lib\joda-convert-1.3.jar;%APP_HOME%\lib\jzlib-1.0.7.jar;%APP_HOME%\lib\jcifs-1.3.17.jar;%APP_HOME%\lib\bcprov-jdk15on-1.49.jar;%APP_HOME%\lib\dom4j-1.6.1.jar;%APP_HOME%\lib\commons-net-2.0.jar;%APP_HOME%\lib\sshj-0.9.0.jar;%APP_HOME%\lib\jaxen-1.1.6.jar;%APP_HOME%\lib\appserver-api-2014.2.jar;%APP_HOME%\lib\spring-security-core-3.1.3.RELEASE.jar;%APP_HOME%\lib\t2-bus-1.2.1.jar;%APP_HOME%\lib\replacer-2014.2.jar;%APP_HOME%\lib\apache-mime4j-0.6.jar;%APP_HOME%\lib\license-2014.2.jar;%APP_HOME%\lib\jmustache-1.8.jar;%APP_HOME%\lib\jackrabbit-core-2.6.0.jar;%APP_HOME%\lib\jackrabbit-jcr-server-2.6.0.jar;%APP_HOME%\lib\spring-security-web-3.1.3.RELEASE.jar;%APP_HOME%\lib\spring-security-ldap-3.1.3.RELEASE.jar;%APP_HOME%\lib\spring-security-config-3.1.3.RELEASE.jar;%APP_HOME%\lib\jackrabbit-spi-commons-2.6.0.jar;%APP_HOME%\lib\truezip-driver-zip-7.4.3.jar;%APP_HOME%\lib\jackrabbit-jcr-commons-2.6.0.jar;%APP_HOME%\lib\spring-webmvc-3.1.4.RELEASE.jar;%APP_HOME%\lib\jackrabbit-api-2.6.0.jar;%APP_HOME%\lib\spring-jdbc-3.1.4.RELEASE.jar;%APP_HOME%\lib\truezip-file-7.4.3.jar;%APP_HOME%\lib\truezip-kernel-7.4.3.jar;%APP_HOME%\lib\truezip-driver-file-7.4.3.jar;%APP_HOME%\lib\jackrabbit-spi-2.6.0.jar;%APP_HOME%\lib\jdom-2.0.2.jar;%APP_HOME%\lib\commons-lang3-3.1.jar;%APP_HOME%\lib\rhino-1.7R4.jar;%APP_HOME%\lib\rhino-1.7R5-20130223-1.jar;%APP_HOME%\lib\commons-pool-1.6.jar;%APP_HOME%\lib\gson-1.6.jar;%APP_HOME%\lib\closure-compiler-v20130411.jar;%APP_HOME%\lib\dojo-shrinksafe-1.7.2.jar;%APP_HOME%\lib\jruby-stdlib-1.7.6.jar;%APP_HOME%\lib\sass-gems-3.2.1.jar;%APP_HOME%\lib\bourbon-gem-jar-2.1.0.jar;%APP_HOME%\lib\less4j-1.2.0.jar;%APP_HOME%\lib\gmaven-runtime-1.7-1.3.jar;%APP_HOME%\lib\webjars-locator-0.5.jar;%APP_HOME%\lib\jshint-2.1.3.jar;%APP_HOME%\lib\less-1.3.3.jar;%APP_HOME%\lib\emberjs-1.0.0-rc.8.jar;%APP_HOME%\lib\handlebars-1.0.0.jar;%APP_HOME%\lib\coffee-script-1.6.3.jar;%APP_HOME%\lib\jslint-c657984cd7.jar;%APP_HOME%\lib\json2-20110223.jar;%APP_HOME%\lib\jaxb-api-2.2.3.jar;%APP_HOME%\lib\logback-core-1.1.2.jar;%APP_HOME%\lib\xmlpull-1.1.3.1.jar;%APP_HOME%\lib\xpp3_min-1.1.4c.jar;%APP_HOME%\lib\mail-1.4.4.jar;%APP_HOME%\lib\servlet-api-2.5.jar;%APP_HOME%\lib\config-1.0.2.jar;%APP_HOME%\lib\bcpkix-jdk15on-1.49.jar;%APP_HOME%\lib\concurrent-1.3.4.jar;%APP_HOME%\lib\commons-collections-3.2.1.jar;%APP_HOME%\lib\commons-dbcp-1.3.jar;%APP_HOME%\lib\tika-core-1.3.jar;%APP_HOME%\lib\lucene-core-3.6.0.jar;%APP_HOME%\lib\derby-10.5.3.0_1.jar;%APP_HOME%\lib\jackrabbit-webdav-2.6.0.jar;%APP_HOME%\lib\commons-fileupload-1.2.1.jar;%APP_HOME%\lib\spring-ldap-core-1.3.1.RELEASE.jar;%APP_HOME%\lib\spring-context-support-3.1.4.RELEASE.jar;%APP_HOME%\lib\annotations-1.0.0.jar;%APP_HOME%\lib\args4j-2.0.16.jar;%APP_HOME%\lib\json-20090211.jar;%APP_HOME%\lib\jsr305-1.3.9.jar;%APP_HOME%\lib\antlr-runtime-3.4.jar;%APP_HOME%\lib\commons-beanutils-1.8.3.jar;%APP_HOME%\lib\gmaven-feature-support-1.3.jar;%APP_HOME%\lib\gmaven-runtime-support-1.3.jar;%APP_HOME%\lib\groovy-all-1.7.4.jar;%APP_HOME%\lib\ant-1.8.1.jar;%APP_HOME%\lib\jline-0.9.94.jar;%APP_HOME%\lib\jquery-1.9.1.jar;%APP_HOME%\lib\antlr-2.7.7.jar;%APP_HOME%\lib\gmaven-feature-api-1.3.jar;%APP_HOME%\lib\gmaven-runtime-api-1.3.jar;%APP_HOME%\lib\gshell-io-2.0.jar;%APP_HOME%\lib\plexus-utils-2.0.1.jar;%APP_HOME%\lib\qdox-1.10.jar;%APP_HOME%\lib\ant-launcher-1.8.1.jar;%APP_HOME%\lib\slf4j-api-1.7.6.jar;%APP_HOME%\lib\commons-codec-1.7.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\truezip-swing-7.4.3.jar;%APP_HOME%\lib\commons-compress-1.3.jar;%APP_HOME%\lib\joda-time-2.3.jar;%APP_HOME%\lib\protobuf-java-2.5.0.jar;%APP_HOME%\lib\spring-tx-3.1.4.RELEASE.jar

@rem Execute server
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %SERVER_OPTS%  -classpath "%CLASSPATH%" com.xebialabs.xltest.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable SERVER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%SERVER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
