from com.xebialabs.deployit.repository import SearchParameters
from com.xebialabs.deployit.plugin.api.reflect import Type
from com.xebialabs.xltest.domain import TestRun

import datetime

testSetDefinitionId = testRun.testSetDefinition.id

query = SearchParameters().setType(Type.valueOf(TestRun));
testRunCis = repository.listEntities(query);

testRunCis = filter(lambda t: t.testSetDefinition.id == testSetDefinitionId, testRunCis)
testRunCis.sort(key=lambda t: t.startTime)

allResults = []
xs = []
for run in testRunCis:
    events = run.getEvents(queryParameters)
    if events:
        for ev in events:
            if ev.type == 'jmeterresult':
                p = ev.getProperties()
                print 'properties', p
                result = p.get('result')
                if result is None:
                    continue
                allResults.append([p.get('_ts') ,float(result)])

    print 'allResults', allResults

    resultHolder.setResult(
        {
            'title': {
                'text': 'Number of Event stores per second. Trend'
            },
            'tooltip': {
        	    'pointFormat': '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            'credits': {
                'enabled': False
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'xAxis': {
                'type': 'datetime',
                'labels': {
                    'rotation': -45,
                }
            },
            'yAxis': {
                'min': 0
            },
            'series': [{
                'name': 'ElasticSearch Store running locally',
                'data': allResults
            }]
        })