set -e

INSTALL_DIR="${deployed.container.installationHome}"
XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
CENTRAL_CONFIG_DIR="$XLD_HOME/centralConfiguration"
mkdir -p $CENTRAL_CONFIG_DIR

echo "Installing XL Deploy Central Configuration Data into $CENTRAL_CONFIG_DIR"
unzip -o "${deployed.file.path}" -d $CENTRAL_CONFIG_DIR

REPOSITORY_FILE=$CENTRAL_CONFIG_DIR/deploy-repository.yaml

cat > $REPOSITORY_FILE << EOL
xl:
    repository:
        artifacts:
            allow-move: true
            root: build/artifacts
            type: db
        database:
            db-driver-classname: org.apache.derby.client.ClientAutoloadedDriver
            db-password: "admin"
            db-url: jdbc:derby://localhost:1527/xldrepo;create=true;user=admin;password=admin
            db-username: admin
            leak-detection-threshold: 2 minutes
            max-pool-size: 10
EOL
echo "SUCCESS"