set -e
echo "Installing Deploy Server"

INSTALL_DIR="${deployed.container.installationHome}"

if [ ! -d "$INSTALL_DIR" ]; then
  echo "Directory $INSTALL_DIR does not exist. Creating it"
  mkdir -p $INSTALL_DIR
fi

XLD_HOME=$INSTALL_DIR/`basename ${deployed.file.name} .zip`
echo "XL Deploy home is $XLD_HOME"

unzip -qo "${deployed.file.path}" -d "$INSTALL_DIR"

gradle -p $XLD_HOME startIntegrationServer -Pdatabase=derby-network
echo "SUCCESS"
