set -e
echo "Updating Deploy ${deployed.file.name}"

INSTALL_DIR="${deployed.container.installationHome}"
PREVIOUS_XLD_HOME=$INSTALL_DIR/`basename ${previousDeployed.file.name} .zip`
NEW_XLD_HOME=$INSTALL_DIR/`basename ${deployed.file.name} .zip`

echo "Uninstalling ${previousDeployed.file.name}"
gradle -p $PREVIOUS_XLD_HOME shutdownIntegrationServer -Pdatabase=derby-network
rm -rf $PREVIOUS_XLD_HOME

unzip -qo "${deployed.file.path}" -d $INSTALL_DIR

echo "Installing deploy server in $NEW_XLD_HOME"
gradle -p $NEW_XLD_HOME startIntegrationServer -Pdatabase=derby-network

echo "SUCCESS"
