set -e

INSTALL_DIR="${deployed.container.installationHome}"
XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
DEST_DIR="$XLD_HOME/conf"
mkdir -p $DEST_DIR

echo "Installing XL Deploy Config Data into $DEST_DIR"
unzip -o "${deployed.file.path}" -d $DEST_DIR

DEPLOYIT_CONF_FILE=$DEST_DIR/deployit.conf

if [ -f "$DEPLOYIT_CONF_FILE" ]; then
    echo "$DEPLOYIT_CONF_FILE has been found, modifying it".
    echo "Content before modification is:"
    cat $DEPLOYIT_CONF_FILE
    sed '/http.port/d' $DEPLOYIT_CONF_FILE > $DEPLOYIT_CONF_FILE.updated
    mv $DEPLOYIT_CONF_FILE.updated $DEPLOYIT_CONF_FILE
    echo http.port=4516 >> $DEPLOYIT_CONF_FILE
    echo "Content after modification is:"
    cat $DEPLOYIT_CONF_FILE
fi

echo "SUCCESS"
