set -e

echo "Installing XLD"

INSTALL_DIR="${deployed.container.installationHome}"
LICENSE_LOCATION="$INSTALL_DIR/deployit-license.lic"
DEFAULTS_LOCATION="$INSTALL_DIR/setup.defaults"
XLD_HOME=$INSTALL_DIR/`basename ${deployed.file.name} .zip`
LINKED_XLD_HOME=$INSTALL_DIR/xl-deploy-current

if [ ! -d "$INSTALL_DIR" ]; then
  echo "Directory $INSTALL_DIR does not exist. It must be created by a XLD license application"
fi

if [ ! -f "$LICENSE_LOCATION" ]; then
  echo "License for xl-deploy is not found in location $LICENSE_LOCATION"
  exit 1
fi

if [ ! -f "$DEFAULTS_LOCATION" ]; then
  echo "Setup defaults for xl-deploy is not found in location $DEFAULTS_LOCATION"
  exit 1
fi

unzip -qo "${deployed.file.path}" -d "$INSTALL_DIR"
ln -sf $XLD_HOME $LINKED_XLD_HOME

echo "XL Deploy home is $XLD_HOME"

echo "Installing License"
cp -f "$LICENSE_LOCATION" "$LINKED_XLD_HOME/conf/deployit-license.lic"

DEST_DIR="$INSTALL_DIR/derby-repository"
mkdir -p $DEST_DIR

echo "SUCCESS"
