set -e

INSTALL_DIR="${deployed.container.installationHome}"
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -o "${deployed.file.path}" -d $DATA_DIR

XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
ARTIFACTS_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-artifacts' | head -1)
DEST_DIR="$XLD_HOME/repository"

if [ ! -z $ARTIFACTS_DIR ] && [ -d $ARTIFACTS_DIR ]; then
echo "Installing XL Deploy artifacts from $ARTIFACTS_DIR into $DEST_DIR"
mkdir -p $DEST_DIR
cp -rf $ARTIFACTS_DIR/* $DEST_DIR
fi

echo "SUCCESS"
