set -e

INSTALL_DIR="${deployed.container.installationHome}"
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -o "${deployed.file.path}" -d $DATA_DIR

REPO_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-repository' | head -1)
DEST_DIR="$INSTALL_DIR/derby-repository/xldrepo"

if [ ! -z $REPO_DIR ] && [ -d $REPO_DIR ]; then
    echo "Installing XL Deploy Repository from $REPO_DIR into $DEST_DIR"
    mkdir -p $DEST_DIR
    cp -rf $REPO_DIR/* $DEST_DIR
    echo "Starting derby database"
    nohup service derby start
fi

echo "SUCCESS"