set -e

INSTALL_DIR="${deployed.container.installationHome}"
DATA_DIR=$INSTALL_DIR/data

mkdir -p $DATA_DIR
unzip -o "${deployed.file.path}" -d $DATA_DIR

XLD_HOME=$(find "$INSTALL_DIR" -type d -name '*-server' | head -1)
TASKS_DIR=$(find "$DATA_DIR" -type d -name 'xld-ci-explorer-*-tasks' | head -1)
DEST_DIR="$XLD_HOME/work"

if [ ! -z $TASKS_DIR ] && [ -d $TASKS_DIR ]; then
    echo "Installing XL Deploy tasks from $TASKS_DIR into $DEST_DIR"
    mkdir -p $DEST_DIR
    cp -rf $TASKS_DIR/* $DEST_DIR
fi

echo "SUCCESS"