

echo Shutting down the XL Deploy service
set -e
nohup service xl-deploy stop


COUNT=30
url="http://localhost:${container.port}"
while [ $COUNT -gt 0 ]; do
	sleep 2
	if curl --output /dev/null --silent --head --fail "$url"; then
		echo "Waiting for XL Deploy to stop on port ${container.port} ..."
	else
		sleep 5
		echo "XL Deploy has stopped on port ${container.port}"

		echo "Stopping derby database"
		service derby stop
		sleep 2

		exit 0
	fi
    COUNT=$((COUNT-1))
done
echo "XL Deploy did not stop in 1 minute, please check its log files or try again"
exit 1
