angular.module('CompareApp').directive(
    'stringDiff', function () {

        var diffPrettyHtml = function (diffs) {
            var html = [];
            var pattern_amp = /&/g;
            var pattern_lt = /</g;
            var pattern_gt = />/g;
            var pattern_para = /\n/g;
            for (var x = 0; x < diffs.length; x++) {
                var op = diffs[x][0];
                var data = diffs[x][1];
                var text = data.replace(pattern_amp, '&amp;').replace(pattern_lt, '&lt;')
                    .replace(pattern_gt, '&gt;').replace(pattern_para, '&para;<br>');
                switch (op) {
                    case DIFF_INSERT:
                        html[x] = '<ins class="diff-ins">' + text + '</ins>';
                        break;
                    case DIFF_DELETE:
                        html[x] = '<del class="diff-del">' + text + '</del>';
                        break;
                    case DIFF_EQUAL:
                        html[x] = '<span>' + text + '</span>';
                        break;
                }
            }
            return html.join('');
        };

        return {
            restrict: 'A',
            replace: true,
            scope: {
                comparedValue: '=',
                originalValue: '='
            },
            link: function (scope, elem) {

                var dmp = new diff_match_patch();
                var compared = scope.comparedValue;
                var original = scope.originalValue;

                var difference = dmp.diff_main(original, compared);
                dmp.diff_cleanupEfficiency(difference);

                elem.html(diffPrettyHtml(difference));
            }
        }
    });