angular.module('CompareApp').controller('CompareInputController', ['$scope', function($scope) {

    $scope.isLiveToRepoMode = function() {
        return $scope.selectedCIs.length == 1;
    };

    $scope.isEmptyForm = function () {
        return $scope.selectedCIs.length == 0;
    };

    $scope.generateLabelFor = function(ciId, existingLabels) {

        var isLabelUnique = function(label) {return _.indexOf(existingLabels, label) == -1};

        var labelBase = ciId.split('/').pop();

        var label = labelBase, count = 0;

        do {
            if (count > 0) {
                label = labelBase + '-' + count;
            }
            count = count + 1;
        } while (!isLabelUnique(label));

        return label;
    };
}]);