angular.module('CompareApp')
    .filter('xlToList', function() {
        return _.memoize(function(input) {
            return _.reduce(input, function(a, v, k) {
                var r = angular.copy(a);
                r.push({key: k, value: v});
                return r;
            }, []);
        }, JSON.stringify);
    }).filter('singleKey', function() {
        return function(input) {
            return _.filter(_.keys(input), function(key) {return key.indexOf('$') != 0}).pop();
        };
    }).filter('singleValue', function(singleKeyFilter) {
        return function(input) {
            return input[singleKeyFilter(input)];
        };
    });