angular.module('CompareApp').directive(
    'diffReport', ['singleValueFilter',
        function (singleValueFilter) {
            return {
                restrict: 'A',
                templateUrl: 'js/directives/templates/diffReport.html',
                scope: {
                    'showIdentical': '=',
                    'expandAll': '=',
                    'ciDifferences': '=',
                    'labels': '&'
                },
                require: 'ciColumnWidth',
                controller: function ($scope) {

                    var hasDifferences = function(item) {
                        return (_.contains(item.value.ci_paths, null) || !_.isEmpty(item.value.properties));
                    };

                    $scope.expandedCis = {};

                    $scope.$watch('expandAll', function(newValue) {
                        _.each(_.keys($scope.ciDifferences), function(v) {
                            $scope.expandedCis[v] = newValue;
                        });
                    });

                    $scope.statusImageToUse = function(item) {
                        return (hasDifferences(item)) ?  "warning.png" : "checkmark.png";
                    };

                    $scope.originalValue = function(values) {
                        return _.find(singleValueFilter(values), function (v) {
                            return v != null;
                        });
                    };

                    $scope.allIdentical = function() {
                        return _.isEmpty(_.filter($scope.ciDifferences, function(ciDifference) {
                            return !_.isEmpty(ciDifference.properties) || (_.size(_.union(ciDifference.ci_paths)) != 1);
                        }));
                    };

                    var suppliedLabels = $scope.labels();
                    if (suppliedLabels.length == 1) {
                        $scope.reportLabels = [suppliedLabels[0] + ' (Repository)', suppliedLabels[0] + ' (Live)'];
                    } else {
                        $scope.reportLabels = suppliedLabels;
                    }

                }
            }
        }]);