angular.module('CompareApp').directive(
    'taskProgress', ['$q', '$modal', '$timeout', 'TaskService', 'InspectionService', 'pollingInterval', 'enablePollingSequence',
        function ($q, $modal, $timeout, TaskService, InspectionService, pollingInterval, enablePollingSequence) {
            return {
                restrict: 'A',
                templateUrl: 'js/directives/templates/progress.html',
                scope: {
                    taskInfo: '='
                },
                controller: function ($scope, $element, $attrs) {

                    $scope.taskId = null;
                    $scope.taskStepId = null;
                    $scope.taskStateClass = null;
                    $scope.taskText = "";
                    $scope.taskError = null;
                    $scope.deferred = null;
                    $scope.pollingSequence = 1;

                    $scope.setTaskId = function (taskId) {
                        $scope.taskId = taskId;
                        return taskId;
                    };

                    $scope.stageInspection = function () {
                        return InspectionService.prepareInspection($scope.taskInfo.data)
                            .then(function (data) {
                                return InspectionService.createInspectionTask(data).then(null, $scope.discoveryFailed);
                            }, $scope.discoveryFailed)
                            .then($scope.setTaskId);
                    };

                    $scope.continueTask = function () {
                        $scope.clearError();
                        $scope.startTask();
                    };

                    $scope.startTask = function () {
                        $scope.taskInfo.enableDelete = false;
                        return TaskService.startTask($scope.taskId)
                            .then($scope.pollTaskStatus, $scope.discoveryFailed);
                    };

                    $scope.getTaskStepLog = function () {
                        return TaskService.getTaskStepLog($scope.taskId, $scope.taskStepId)
                            .then($scope.saveTaskStepError, $scope.saveTaskStepError);
                    };

                    $scope.clearError = function() {
                        $scope.taskError = null;
                        $scope.taskStateClass = null;
                        $scope.taskInfo.taskError = null;
                    };

                    $scope.saveTaskStepError = function (error) {
                        $scope.taskError = error.step.log;
                        $scope.taskInfo.taskError = error.step.log;
                    };

                    $scope.pollTaskStatus = function () {
                        var params = null;
                        if (enablePollingSequence) {
                            params = {nonsense: $scope.pollingSequence++}
                        }
                        TaskService.getTask($scope.taskId, params).then($scope.evaluateTaskStatus, $scope.discoveryFailed);
                    };

                    $scope.evaluateTaskStatus = function (taskInfo) {
                        var task = taskInfo.task;

                        if ($scope.abortRequested) {
                            $scope.taskText = "Aborting...";
                            return;
                        }

                        $scope.taskStepId = task._currentStep;
                        var stepCount = task._currentStep + "/" + task._totalSteps;
                        if (task._state == "EXECUTED") {
                            $scope.pollingSequence = 1;
                            $scope.taskStateClass = "discovery-done";
                            $scope.taskText = "Finished steps " + stepCount;
                            TaskService.archiveTask($scope.taskId).then($scope.discoverySucceeded, $scope.discoveryFailed);
                        } else if (_.indexOf(TaskService.failedTaskStates, task._state) > -1) {
                            $scope.taskText = "Failed step " + stepCount;
                            $scope.taskStateClass="discovery-failed";
                            $scope.getTaskStepLog();
                        } else {
                            $scope.taskStateClass = "discovery-active";
                            $scope.taskText = "Discovering (" + stepCount + ")";
                            $timeout($scope.pollTaskStatus, pollingInterval);
                        }
                    };

                    $scope.showLogsPopup = function () {
                        $modal.open({
                            template: '<div class="show-logs-popup"><pre class="pre-scrollable">' + $scope.taskError + '</pre></div>'
                        });
                    };

                    $scope.abortTask = function () {
                        if($scope.taskId != null) {
                            TaskService.abortTask($scope.taskId);
                        }
                        $scope.abortDeferred.resolve('aborted');
                        $scope.taskInfo.enableDelete = true;
                    };

                    $scope.discoverySucceeded = function () {
                        $scope.taskInfo.taskId = $scope.taskId;
                        $scope.taskInfo.error = null;
                        $scope.deferred.resolve($scope.taskId);
                    };

                    $scope.discoveryFailed = function (error) {
                        $scope.taskInfo.error = error;
                        $scope.deferred.reject(error);
                        return $q.reject(error);
                    };

                    $scope.start = function () {
                        $scope.deferred = $q.defer();
                        $scope.stageInspection().then($scope.startTask);
                        return $scope.deferred.promise;
                    };

                    $scope.destroy = function () {
                        $scope.cleanupDeferred = $q.defer();
                        //cleanup code here
                        $scope.cleanupDeferred.resolve("Done");    // remove when clean up code inserted
                        return $scope.cleanupDeferred.promise;
                    };

                    $scope.abort = function() {
                        $scope.abortDeferred = $q.defer();
                        $scope.abortRequested = true;
                        $scope.abortTask();
                        return $scope.abortDeferred.promise;
                    };
                    //bind taskInfo to this directive

                    $scope.taskInfo.start = function () {
                        return $scope.start();
                    };

                    $scope.taskInfo.destroy = function () {
                        return $scope.destroy();
                    };

                    $scope.taskInfo.continueTask = function () {
                        return $scope.continueTask();
                    };

                    $scope.taskInfo.abort = function() {
                        return $scope.abort();
                    };
                },

                link: function (scope, elem) {
                    return;
                }
            }

        }]);
