angular.module('CompareApp')

    .filter('idTruncateRoot', function() {
        return function(ciId) {
            var index = ciId.indexOf("/");
            return (index > -1 && (index+1 < ciId.length)) ? ciId.substring(index+1) : ciId;
        }
    })

    .filter('withoutIdentical', function() {
        return function(items, isActive) {
            if (!isActive) return items;

            return _.filter(items, function(item) {
                return (_.contains(item.value.ci_paths, null) || !_.isEmpty(item.value.properties));
            });
        }
    })

    .filter('onlyOfType', function() {
        return function(items, ofType) {
            if (!ofType) return items;

            return _.filter(items, function(item) { return item.type == ofType; });
        }
    });


