angular.module('CompareApp').controller('ConfigCompareController', ['$rootScope', '$window', '$scope', '$q', '$timeout', 'CompareService',
    function ($rootScope, $window, $scope, $q, $timeout, CompareService) {

        $scope.selectedCIs = [];
        $scope.selectCiEnabled = true;
        $scope.ciDifferences = null;
        $scope.compareInProgress = false;
        $scope.discoverableCis = [];
        $scope.selectedType = null;
        $scope.hiddenDiscoverableCis = [];
        $scope.abortInProgress = false;
        $scope.compareErrors = [];

        $(window).unload(function () {
            $scope.abort();
        });

        window.onbeforeunload = function (e) {
            if ($scope.compareInProgress) {
                e = e || window.event;
                var msg = 'Please note that all compare tasks in progress will be aborted when you leave this page';

                if (e) { /* For IE and Firefox */
                    e.returnValue = msg;
                }

                return msg; /* For Safari / chrome */
            }
        };

        $scope.usedLabels = function() {
            return _.map($scope.selectedCIs, function(selectedCi) {
               return selectedCi.label;
            });
        };

        $scope.searchForDiscoverableCis = function () {
            CompareService.searchForDiscoverableCis()
                .then(function (cis) {
                    $scope.discoverableCis = cis;
                }, function (error) {
                    //TODO: Show error
                });
        };

        $scope.updateErrorMessages = function () {
            $scope.compareErrors = _.compact(_.pluck($scope.selectedCIs, "error"));
        };

        $scope.calculateDifferences = function () {
            CompareService.findDifferences(_.pluck($scope.selectedCIs, "taskId"))
                .then(function (diff) {
                    $scope.compareInProgress = false;
                    $scope.ciDifferences = diff;
                    $scope.resetErrors();
                }, function (error) {
                    $scope.compareErrors = [error];
                });
        };

        $scope.compare = function () {
            $scope.compareInProgress = true;
            $scope.selectCiEnabled = false;
            $scope.compareErrors = [];

            var counter = 0;
            var taskPromises = _.invoke($scope.selectedCIs, "start");
            _.each(taskPromises, function (tp) {
                tp.then(function () {
                    counter++;
                    if (counter == $scope.selectedCIs.length) {
                        $scope.calculateDifferences();
                    }
                }, function () {
                    $scope.updateErrorMessages();
                });
            });
        };

        $scope.abort = function () {
            $scope.abortInProgress = true;
            $scope.compareErrors = [];

            var counter = 0;
            var taskPromises = _.invoke($scope.selectedCIs, "abort");
            _.each(taskPromises, function (tp) {
                tp.then(function (result) {
                    counter++;
                    if (counter == $scope.selectedCIs.length) {
                        $scope.reset();
                    }
                }, function (error) {
                    $scope.updateErrorMessages();
                    $scope.abortInProgress = false;
                });
            });
        };

        $scope.reset = function () {
            $scope.ciDifferences = null;
            $scope.resetErrors();

            $scope.selectedCIs = [];
            $scope.compareInProgress = false;
            $scope.selectCiEnabled = true;
            $scope.selectedType = null;
            $scope.searchForDiscoverableCis();
        };

        $scope.resetErrors = function () {
            $scope.compareErrors = [];
        };

        $scope.showCompareButton = function () {
            return $scope.selectedCIs.length > 0 && !$scope.compareInProgress;
        };

        $scope.cisLimitReached = function () {
            return $scope.selectedCIs.length == 4;
        };

        $scope.comparisonEnabled = function () {
            return !$scope.compareInProgress;
        };

        $scope.abortEnabled = function () {
            return $scope.compareInProgress
        };

        $scope.newCiSelected = function (ci, label) {
            $scope.ciDifferences = null;

            if ($scope.selectedCIs.length < 4) {
                var selectionIndex = _.findIndex($scope.discoverableCis, { 'id': ci.id });
                $scope.discoverableCis.splice(selectionIndex, 1);
                $scope.hiddenDiscoverableCis.push(ci);
                $scope.selectedType = ci.type;
                $scope.selectedCIs.push({'data': ci.id, 'label': label, enableDelete: true, taskError: null});
            }
        };

        $scope.deleteCI = function (index) {
            var taskInfo = $scope.selectedCIs[index];
            taskInfo.destroy().then(function () {
                $scope.ciDifferences = null;
                var selectionIndex = _.findIndex($scope.hiddenDiscoverableCis, { 'id': $scope.selectedCIs[index].data });
                var ci = $scope.hiddenDiscoverableCis[selectionIndex];
                $scope.hiddenDiscoverableCis.splice(selectionIndex, 1);
                $scope.discoverableCis.push(ci);

                $scope.selectedCIs.splice(index, 1);

                if ($scope.selectedCIs.length == 0) {
                    $scope.selectedType = null;
                }

                $scope.updateErrorMessages();
            });
        };

    }]);