angular.module('Environments').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('web-src/environments/environments.html',
    "<div class=\"xl-deploy-space xl-environments\">\n" +
    "    <xl-notify-view></xl-notify-view>\n" +
    "\n" +
    "    <div class=\"part sidebar\">\n" +
    "        <div class=\"header\">\n" +
    "            Environments\n" +
    "        </div>\n" +
    "        <div class=\"xl-toolbar\">\n" +
    "            <div ng-click=\"newEnvironment()\" id=\"new-environment\" class=\"xl-button xl-secondary xl-toolbar-item svg-icon icon_add_environment\" xl-tooltip=\"Create a new environment\"></div>\n" +
    "        </div>\n" +
    "        <div id=\"environments-list\" class=\"content tree-container\">\n" +
    "            <div tree-view current-node=\"currentNode\" options=\"treeOptions\" datasource=\"findNodeChildren\"  nodes=\"environments\" ng-if=\"environments.length > 0\"></div>\n" +
    "            <div ng-if=\"environments.length === 0\" class=\"empty-tree\">\n" +
    "                No environments or versions available\n" +
    "                </br>\n" +
    "                <div class=\"xl-button xl-secondary button-welcome svg-icon icon_add_environment\" ng-click=\"newEnvironment('')\">\n" +
    "                    New environment\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"part detail\">\n" +
    "        <div class=\"xl-tabs\">\n" +
    "            <div tab-header></div>\n" +
    "        </div>\n" +
    "        <div tab-view></div>\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n" +
    "\n"
  );


  $templateCache.put('web-src/environments/tabs/environment/container/container-modal.html',
    "<h4>Add new container for {{ environmentId }}</h4>\n" +
    "\n" +
    "<div class=\"scrollable\">\n" +
    "    <div class=\"xl-form-wrapper wizard-step-name-env\">\n" +
    "        <form name=\"containerNameForm.internal\" id=\"new-env-name-form\" class=\"form-horizontal\" role=\"form\">\n" +
    "            <div class=\"input-component\">\n" +
    "                <div xl-widget-string ng-model=\"container.name\" options=\"{label: 'Container name', name: 'containerName', required: true}\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <!-- Type -->\n" +
    "            <div class=\"input-component\">\n" +
    "                <div class=\"input-label\">\n" +
    "                    <div xl-widget-label ng-model=\"container.type\" options=\"{label: 'Container type', required: true}\"></div>\n" +
    "                </div><!--\n" +
    "            ---><div class=\"input-form\">\n" +
    "                    <div xl-widget-autocomplete-type=\"containerTypeNames\" ng-model=\"container.type\" on-select=\"onTypeSelect(type)\"\n" +
    "                         is-required=\"true\" is-disabled=\"containerTypeNames.length === 1\"></div>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "\n" +
    "            <!-- Path -->\n" +
    "            <div class=\"input-component\" ng-show=\"typeDescriptor.root\">\n" +
    "                <div class=\"input-label\">\n" +
    "                    <label for=\"container-path\">Path</label>\n" +
    "                </div><!--\n" +
    "            ---><div class=\"input-form\">\n" +
    "                    <div id=\"container-path\" xl-widget-autocomplete ng-model=\"container.path\"\n" +
    "                         handlers=\"containerPathAutocompleteHandlers\" select-mode=\"false\" is-required=\"false\"></div>\n" +
    "                    <span class=\"xl-field-description\">Enter a path to set up the directory structure</span>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </form>\n" +
    "\n" +
    "        <div xl-dip-dynamic-form ng-model=\"container\" form-model=\"formModel\" metadata=\"typeDescriptor\"\n" +
    "             handlers=\"dipHandlers.formHandlers\"></div>\n" +
    "\n" +
    "        <div class=\"xl-button-container\">\n" +
    "            <button ng-click=\"close()\" class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "            <button ng-click=\"create()\" class=\"xl-button xl-primary\"\n" +
    "                    ng-disabled=\"!(!!containerNameForm.internal.$valid && !!formModel.$valid)\">Create</button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/environment/edit-dictionary-modal/edit-dictionary-modal.html',
    "<h4>Edit {{dictionary.id}}</h4>\n" +
    "\n" +
    "<div class=\"scrollable\">\n" +
    "    <div class=\"xl-form-wrapper\">\n" +
    "        <form name=\"formEditDictionary.form\">\n" +
    "            <div class=\"input-component\">\n" +
    "                <div xl-dip-string ng-model=\"dictionary.id\"\n" +
    "                     metadata=\"{name: 'dictionaryId', label: 'Dictionary name', placeholder: ''}\"\n" +
    "                     display-mode=\"'edition'\" is-disabled=\"true\"></div>\n" +
    "\n" +
    "                <span class=\"xl-field-description\">Please provide a unique name for the dictionary.</span>\n" +
    "                <div id=\"xl-error\" ng-show=\"postError\" xl-widget-alert-message on-dismiss=\"postError=undefined\">{{ postError }}</div>\n" +
    "            </div>\n" +
    "\n" +
    "            <div class=\"map-dictionary\">\n" +
    "                <div xl-dip-map-string-string ng-model=\"dictionary.entries\" metadata=\"{name: 'dictionaryEntries', label: ''}\"\n" +
    "                     display-mode=\"dictionary.mode\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <div class=\"xl-button-container\">\n" +
    "                <button ng-click=\"cancel()\" class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "                <button ng-click=\"create()\" class=\"save xl-button xl-primary\"\n" +
    "                        ng-disabled=\"!isValidDictionary()\">Save</button>\n" +
    "            </div>\n" +
    "        </form>\n" +
    "    </div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/environment/environment-ci-visual.html',
    "<div id=\"environment-visual-tab\">\n" +
    "\t<div class=\"xl-row\">\n" +
    "\t\t<div class=\"xl-column-main\">\n" +
    "\t\t\t<div class=\"xl-form-wrapper\" ng-if=\"isLoaded()\">\n" +
    "\t\t\t\t<h4>Environment</h4>\n" +
    "\n" +
    "\t\t\t\t<div class=\"xl-container xl-container-margin-top\">\n" +
    "\t\t\t\t\t<div class=\"input-component environment-name\">\n" +
    "\t\t\t\t\t\t<div class=\"input-label\">\n" +
    "\t\t\t\t\t\t\t<div xl-widget-label ng-model=\"$tabData.environmentData.environmentId\"\n" +
    "\t\t\t\t\t\t\t\t options=\"{label: 'Environment name'}\"></div>\n" +
    "\t\t\t\t\t\t</div><!--\n" +
    "\t\t\t\t\t---><div class=\"input-form\">{{ $tabData.environmentId }}</div>\n" +
    "\t\t\t\t\t</div>\n" +
    "\t\t\t\t</div>\n" +
    "\n" +
    "\t\t\t\t<div class=\"xl-container xl-container-margin-top\">\n" +
    "\t\t\t\t\t<div xl-dip-set-of-ci ng-model=\"$tabData.environmentData.members\"\n" +
    "\t\t\t\t\t\t metadata=\"{name: 'Containers', label: 'Containers'}\"\n" +
    "\t\t\t\t\t\t obj-label=\"id\" display-mode=\"$tabData.mode\" handlers=\"envContainersAutocompleteHandlers\"\n" +
    "\t\t\t\t\t\t  open-on-click=\"true\"></div>\n" +
    "\t\t\t\t</div>\n" +
    "\n" +
    "\t\t\t\t<div class=\"xl-container xl-container-margin-top\">\n" +
    "\t\t\t\t\t<div xl-dip-set-of-ci ng-model=\"$tabData.environmentData.dictionaries\"\n" +
    "\t\t\t\t\t\t metadata=\"{name: 'Dictionaries', label: 'Dictionaries'}\"\n" +
    "\t\t\t\t\t\t obj-label=\"id\" display-mode=\"$tabData.mode\" handlers=\"envDictionariesAutocompleteHandlers\"\n" +
    "\t\t\t\t\t\t open-on-click=\"true\"></div>\n" +
    "\t\t\t\t</div>\n" +
    "\n" +
    "\t\t\t\t<h4>Advanced properties</h4>\n" +
    "\n" +
    "\t\t\t\t<div xl-dip-dynamic-form ng-model=\"$tabData.environmentData\"\n" +
    "\t\t\t\t\t form-model=\"environmentDynamicFormModel\" metadata=\"environmentMetadata\"\n" +
    "\t\t\t\t\t handlers=\"dipHandlers.formHandlers\" display-mode=\"$tabData.mode\"></div>\n" +
    "\n" +
    "\t\t\t\t<div class=\"xl-button-container\">\n" +
    "\t\t\t\t\t<button id=\"editMode\" class=\"xl-button xl-primary\" ng-click=\"editEnvironment()\" ng-if=\"false\">Edit</button>\n" +
    "\t\t\t\t</div>\n" +
    "\t\t\t</div>\n" +
    "\t\t</div><!--\n" +
    "\t---><div class=\"xl-column-aside\" xl-sticky-parent>\n" +
    "\t\t\t<div class=\"xl-help-block\" xl-sticky>\n" +
    "\t\t\t\t<h4>Help</h4>\n" +
    "\t\t\t\t\t<p>An environment is a group of infrastructure and middleware items such as hosts, application servers, web servers, and clusters. You can use these items as targets when you deploy an application.</p>\n" +
    "\t\t\t</div>\n" +
    "\t\t</div>\n" +
    "\t</div>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "\n" +
    "\n" +
    "\n"
  );


  $templateCache.put('web-src/environments/tabs/environment/environment-ci.html',
    "<div class=\"content\" id=\"environment-tab\">\n" +
    "  <div ng-if=\"$tabData.mode === 'visual'\">\n" +
    "\t  <div ng-include=\"'web-src/environments/tabs/environment/environment-ci-visual.html'\"></div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div ng-if=\"$tabData.mode !== 'visual'\" xl-widget-wizard navigable=\"true\" on-finish=\"\" steps=\"$tabData.wizardStepsState\">\n" +
    "    <div xl-wizard-step wz-title=\"Name environment\">\n" +
    "      <div class=\"environment-tab-content\" ng-init=\"newEnvironmentForm= {}\">\n" +
    "        <div class=\"xl-row\">\n" +
    "          <div class=\"xl-column-main\">\n" +
    "            <div ng-include=\"'web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-name-env.html'\"></div>\n" +
    "            <div class=\"xl-button-container\">\n" +
    "              <button close-ui-tab class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "              <button ng-click=\"verifyEnvNotExistAndGotoNextStep()\" class=\"xl-button xl-primary\" ng-disabled=\"environmentForms.envNameForm.$invalid\">\n" +
    "                Next\n" +
    "              </button>\n" +
    "            </div>\n" +
    "          </div><!--\n" +
    "\t  ---><div class=\"xl-column-aside\" xl-sticky-parent>\n" +
    "            <div class=\"xl-help-block\" xl-sticky>\n" +
    "              <h4>Help</h4>\n" +
    "                <p>To start creating an environment, provide a name and, optionally, a directory where the environment should be stored. You can use directories to organize and set permissions on environments. The environment name must be unique within its directory.</p>\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div xl-wizard-step wz-title=\"Set up container\">\n" +
    "      <div class=\"environment-tab-content\">\n" +
    "        <div class=\"xl-row\">\n" +
    "          <div class=\"xl-column-main\">\n" +
    "            <div ng-include=\"'web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-set-container.html'\"></div>\n" +
    "            <div class=\"xl-button-container\">\n" +
    "              <button close-ui-tab class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "              <button xl-wizard-previous class=\"xl-button xl-secondary\">Previous</button>\n" +
    "              <button id=\"next-container\" ng-click=\"verifyContainerIsNotSelectAndGotoNextStep()\" class=\"xl-button xl-primary\">Next</button>\n" +
    "            </div>\n" +
    "          </div><!--\n" +
    "\t  ---><div class=\"xl-column-aside\" xl-sticky-parent>\n" +
    "            <div class=\"xl-help-block\" xl-sticky>\n" +
    "              <h4>Help</h4>\n" +
    "              <p>To add a new container to the environment:</p>\n" +
    "              <ol>\n" +
    "                  <li>Click <strong>Add new container</strong>.</li>\n" +
    "                  <li>Select the container type. If the type depends on other container types, XL Deploy automatically adds them to the list of containers.</li>\n" +
    "                  <li>For each container in the list, choose whether you want to create a new container or select an existing one.</li>\n" +
    "                  <li>If you choose to create a new container, you will be asked to provide:\n" +
    "                      <ul>\n" +
    "                          <li>A name for the container</li>\n" +
    "                          <li>Additional properties based on the configuration item type</li>\n" +
    "                      </ul>\n" +
    "                  </li>\n" +
    "                  <li>When you finish configuring the containers in the list, click <strong>Add to environment</strong>.</li>\n" +
    "                </ol>\n" +
    "              <p>To add an existing container to the environment:</p>\n" +
    "                <ol>\n" +
    "                    <li>Click <strong>Select existing container</strong>.</li>\n" +
    "                    <li>Search for the container name or locate the container in the list.</li>\n" +
    "                    <li>Click the container name to add it to the environment.</li>\n" +
    "                </ol>\n" +
    "              <p>When you are finished adding containers to the environment, click <strong>Next</strong>.</p>\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div xl-wizard-step wz-title=\"Set up dictionary\">\n" +
    "      <div class=\"environment-tab-content\">\n" +
    "        <div class=\"xl-row\">\n" +
    "          <div class=\"xl-column-main\">\n" +
    "            <div ng-include=\"'web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-set-dictionary.html'\"></div>\n" +
    "            <div class=\"xl-button-container\">\n" +
    "              <button close-ui-tab class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "              <button xl-wizard-previous class=\"xl-button xl-secondary\">Previous</button>\n" +
    "              <button id=\"next-dico\" ng-click=\"verifyDictonariesIsNotSelectAndGotoNextStep()\" class=\"xl-button xl-primary\">Next</button>\n" +
    "            </div>\n" +
    "          </div><!--\n" +
    "      ---><div class=\"xl-column-aside\" xl-sticky-parent>\n" +
    "            <div class=\"xl-help-block\" xl-sticky>\n" +
    "              <h4>Help</h4>\n" +
    "              <p>To add a new dictionary to the environment:</p>\n" +
    "              <ol>\n" +
    "                  <li>Click <strong>Add new dictionary</strong>.</li>\n" +
    "                  <li>Provide a name for the dictionary.</li>\n" +
    "                  <li>For each dictionary entry, provide a key and a value.</li>\n" +
    "                  <li>When you are finished adding entries to the dictionary, click <strong>Add to environment</strong>.</li>\n" +
    "              </ol>\n" +
    "              <p>To add an existing dictionary to the environment:</p>\n" +
    "              <ol>\n" +
    "                  <li>Click <strong>Select existing dictionary</strong>.</li>\n" +
    "                  <li>Search for the dictionary name or locate the dictionary in the list.</li>\n" +
    "                  <li>Click the dictionary name to add it to the environment.</li>\n" +
    "              </ol>\n" +
    "              <p>When you are finished adding dictionaries to the environment, click <strong>Next</strong>.</p>\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div xl-wizard-step wz-title=\"Advanced properties\">\n" +
    "      <div class=\"environment-tab-content\">\n" +
    "        <div class=\"xl-row\">\n" +
    "          <div class=\"xl-column-main\">\n" +
    "            <div ng-include=\"'web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-advanced-properties.html'\"></div>\n" +
    "            <div class=\"xl-button-container\">\n" +
    "              <button close-ui-tab class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "              <button xl-wizard-previous class=\"xl-button xl-secondary\">Previous</button>\n" +
    "              <button value=\"Save\" class=\"xl-button xl-primary\" ng-click=\"saveEnvironment()\"\n" +
    "                      ng-disabled=\"environmentForms.environmentDynamicFormModel.$invalid\">Save\n" +
    "              </button>\n" +
    "            </div>\n" +
    "          </div><!--\n" +
    "\t  ---><div class=\"xl-column-aside\" xl-sticky-parent>\n" +
    "            <div class=\"xl-help-block\" xl-sticky>\n" +
    "              <h4>Help</h4>\n" +
    "              \t<strong>Mail</strong>\n" +
    "\t\t\t\t<p>You can optionally specify an SMTP server that XL Deploy can use to send an email notification when it reaches a manual process step in a deployment to this environment. A manual process step pauses the deployment so that you can take manual actions. After the manual actions are finished, you can resume the deployment.</p>\n" +
    "\n" +
    "\t\t\t\t<strong>Triggers</strong>\n" +
    "\t\t\t\t<p>You can optionally use triggers to send email notifications for events that happen in this environment. For example, XL Deploy can send an email when a deployment to this environment completes successfully or when a step in the deployment plan fails. The email will be sent using the SMTP server that is assigned to the trigger. You can add multiple triggers to an environment.</p>\n" +
    "                \n" +
    "                <p>Click <strong>Save</strong> to finish creating the environment.</p>\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-advanced-properties.html',
    "<div class=\"form-wrapper\">\n" +
    "  <div class=\"wizard-step-advanced-properties\">\n" +
    "    <h4>Advanced properties</h4>\n" +
    "\n" +
    "    <div xl-dip-dynamic-form ng-model=\"$tabData.environmentData\"\n" +
    "         form-model=\"environmentDynamicFormModel\" metadata=\"environmentMetadata\"\n" +
    "         handlers=\"dipHandlers.formHandlers\" display-mode=\"$tabData.mode\"></div>\n" +
    "\n" +
    "  </div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-name-env.html',
    "<div class=\"xl-form-wrapper wizard-step-name-env\">\n" +
    "  <form name=\"environmentForms.envNameForm\" id=\"new-env-name-form\" class=\"form-horizontal\" role=\"form\">\n" +
    "    <div ng-switch on=\"$tabData.mode\">\n" +
    "      <div ng-switch-when=\"creation\">\n" +
    "        <h4>Name environment</h4>\n" +
    "\n" +
    "        <div>To start creating an environment, enter a name and, optionally, the directory where it should be saved. Click Next to add middleware containers to the\n" +
    "          environment.\n" +
    "        </div>\n" +
    "      </div>\n" +
    "      <h4 ng-switch-when=\"edition\">Edit environment</h4>\n" +
    "      <h4 ng-switch-default>Environment</h4>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-10\">\n" +
    "      <div class=\"input-component environment-name\">\n" +
    "        <div class=\"input-label\">\n" +
    "          <div xl-widget-label ng-model=\"$tabData.environmentData.environmentId\"\n" +
    "               options=\"{label: 'Environment name', required: true}\"></div>\n" +
    "        </div><!--\n" +
    "    ---><div class=\"input-form\">\n" +
    "          <div ng-show=\"$tabData.mode !== 'visual'\">\n" +
    "            <div xl-widget-autocomplete ng-model=\"$tabData.environmentId\"\n" +
    "                 handlers=\"envPathAutocompleteHandlers\" select-mode=\"false\" is-required=\"true\"></div>\n" +
    "            <span class=\"xl-field-description\">Enter an environment name and directory</span>\n" +
    "\n" +
    "          </div>\n" +
    "\n" +
    "          <div ng-show=\"$tabData.mode==='visual'\" for=\"environment-path\">{{ $tabData.environmentId }}</div>\n" +
    "        </div>\n" +
    "            <div ng-show=\"$tabData.postEnvError\" xl-widget-alert-message\n" +
    "                 on-dismiss=\"$tabData.postEnvError=undefined\">{{ $tabData.postEnvError }}\n" +
    "            </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "  </form>\n" +
    "</div>\n"
  );


  $templateCache.put('web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-set-container.html',
    "<div class=\"xl-form-wrapper wizard-step-set-container\">\n" +
    "  <h4>Add container to {{$tabData.environmentId}}</h4>\n" +
    "  <div>Add web servers, load balancers, and other containers to your environment.</div>\n" +
    "\n" +
    "  <div class=\"xl-container xl-container-margin-top selected-containers\">\n" +
    "    <div xl-dip-set-of-ci ng-model=\"$tabData.environmentData.members\"\n" +
    "         metadata=\"{name: 'Containers', label: 'Containers in environment', required: false}\"\n" +
    "         obj-label=\"id\" display-mode=\"$tabData.mode\" handlers=\"envContainersAutocompleteHandlers\"\n" +
    "         new-item-suffix=\" (New Container)\" open-on-click=\"true\" is-input-visible=\"false\" empty-placeholder=\"No containers added yet\"></div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div class=\"add-or-select-existing-block\">\n" +
    "    <div class=\"input-component\">\n" +
    "      <div class=\"input-label\">\n" +
    "        <label>Add containers</label>\n" +
    "      </div><!--\n" +
    "  ---><div class=\"input-form\">\n" +
    "        <form>\n" +
    "          <input type=\"radio\" ng-model=\"$tabData.containerChoice\" value=\"create\">Add new container<br/>\n" +
    "          <input type=\"radio\" ng-model=\"$tabData.containerChoice\" value=\"existing\">Select existing container<br/>\n" +
    "        </form>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div ng-if=\"$tabData.containerChoice==='existing'\" class=\"container-existing xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-33\">\n" +
    "      <div xl-widget-item-selector handlers=\"existingContainersHandlers\" ng-model=\"$tabData.environmentData.members\"\n" +
    "           options=\"{ description : 'Add an existing container to the environment: ', multiple: true }\" obj-label=\"id\"></div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div ng-if=\"$tabData.containerChoice==='create'\" class=\"container-new xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-33\">\n" +
    "      <div>Set up a new container for the environment:</div>\n" +
    "\n" +
    "      <!-- Type -->\n" +
    "      <div class=\"input-component\">\n" +
    "        <div class=\"input-label\">\n" +
    "          <div xl-widget-label ng-model=\"$tabData.newContainerType\" options=\"{label: 'Container type'}\"></div>\n" +
    "        </div><!--\n" +
    "    ---><div class=\"input-form\">\n" +
    "          <div xl-widget-autocomplete-type=\"containerTypeNames\" ng-model=\"$tabData.newContainerType\" on-select=\"newContainerTypeSelected(type)\" is-required=\"false\" is-disabled=\"false\"></div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "      <!-- Container Hierarchy -->\n" +
    "      <div class=\"\">\n" +
    "        <div class=\"container-hierarchy-item\" data-ng-repeat=\"containerBundle in $tabData.containerHierarchyBundles\">\n" +
    "          <span class=\"container-order\">{{$index+1}}.</span>\n" +
    "\n" +
    "          <span ng-if=\"!containerBundle.displayButton()\" class=\"container-title container-title-selected\" >{{containerBundle.getTitle().title}}</span>\n" +
    "\n" +
    "          <span ng-if=\"containerBundle.displayButton()\">\n" +
    "            <a href=\"#\" class=\"inline-btn add\" ng-click=\"createNewContainer(containerBundle)\" ng-class=\"{'disabledContainerBtn': !containerBundle.activeButton()}\"><span>Create new</span></a>\n" +
    "            <span class=\"type-placeholder\">or</span>\n" +
    "            <a href=\"#\" class=\"inline-btn select\" ng-click=\"selectExistingContainer(containerBundle)\" ng-class=\"{'disabledContainerBtn': containerBundle.isNewContainer()}\"><span>Select existing</span></a>\n" +
    "\n" +
    "            <span ng-if=\"$index === 0\" class=\"type-placeholder\">connection ({{containerBundle.getTitle().title}})</span>\n" +
    "            <span ng-if=\"$index > 0\" class=\"type-placeholder\">{{containerBundle.getTitle().title}}</span>\n" +
    "          </span>\n" +
    "          \n" +
    "          <span ng-if=\"!containerBundle.displayButton()\">\n" +
    "            <a href=\"#\" class=\"inline-btn cross\" ng-click=\"containerBundle.clearContainerAndChild()\"/>\n" +
    "          </span>\n" +
    "\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "      <div class=\"xl-button-container\">\n" +
    "        <button type=\"button\" class=\"xl-button xl-primary\" ng-click=\"addContainer()\" ng-disabled=\"isValidContainer()\">Add to environment</button>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/environment/environment-wizard-steps/environment-ci-step-set-dictionary.html',
    "<div class=\"xl-form-wrapper wizard-step-set-dictionaries\">\n" +
    "    <h4>Set up dictionaries for {{$tabData.environmentId}}</h4>\n" +
    "\t<div>Dictionaries are sets of key-value pairs that contain environment-specific values, such as user names and file paths.</div>\n" +
    "\n" +
    "\t<div class=\"xl-container xl-container-margin-top selected-containers\">\n" +
    "\t\t<div xl-dip-set-of-ci ng-model=\"$tabData.environmentData.dictionaries\"\n" +
    "\t\t\t metadata=\"{name: 'Dictionaries', label: 'Dictionaries in environment', required: false}\"\n" +
    "\t\t\t obj-label=\"id\" display-mode=\"$tabData.mode\" handlers=\"envDictionariesAutocompleteHandlers\"\n" +
    "\t\t\t new-item-suffix=\" (New Dictionary)\" open-on-click=\"true\" is-input-visible=\"false\" empty-placeholder=\"No dictionaries added yet\"></div>\n" +
    "\t</div>\n" +
    "\n" +
    "\t<div class=\"add-or-select-existing-block\">\n" +
    "\t\t<div class=\"input-component\">\n" +
    "\t\t\t<div class=\"input-label\">\n" +
    "\t\t\t\t<label>Add dictionary</label>\n" +
    "\t\t\t</div><!--\n" +
    "\t\t---><div class=\"input-form\">\n" +
    "\t\t\t\t<form>\n" +
    "\t\t\t\t\t<input type=\"radio\" ng-model=\"$tabData.dictionaryChoice\" value=\"create\">Add new dictionary<br/>\n" +
    "\t\t\t\t\t<input type=\"radio\" ng-model=\"$tabData.dictionaryChoice\" value=\"existing\">Select existing dictionary<br/>\n" +
    "\t\t\t\t</form>\n" +
    "\t\t\t</div>\n" +
    "\t\t</div>\n" +
    "\n" +
    "\t\t<div class=\"xl-container xl-container-margin-top xl-container-top-triangle xl-container-top-triangle-33\">\n" +
    "\t\t\t<div ng-if=\"$tabData.dictionaryChoice==='existing'\" class=\"dictionary-existing\">\n" +
    "\t\t\t\t<div xl-widget-item-selector handlers=\"existingDictionariesHandlers\" ng-model=\"$tabData.environmentData.dictionaries\"\n" +
    "\t\t\t\t\t options=\"{ description : 'Add existing dictionary to the environment: ', multiple: true }\" obj-label=\"id\"></div>\n" +
    "\t\t\t</div>\n" +
    "\n" +
    "\t\t\t<div ng-if=\"$tabData.dictionaryChoice==='create'\" class=\"dictionary-new\">\n" +
    "\t\t\t\t<div>Set up a new dictionary for the environment:</div>\n" +
    "\n" +
    "\t\t\t\t<div class=\"input-component\">\n" +
    "\t\t\t\t\t<div xl-dip-string ng-model=\"$tabData.newDictionary.id\"\n" +
    "\t\t\t\t\t\t metadata=\"{name: 'newDictionaryId', label: 'Dictionary name', placeholder: ''}\"\n" +
    "\t\t\t\t\t\t display-mode=\"$tabData.mode\"></div>\n" +
    "\n" +
    "\t\t\t\t\t<span class=\"xl-field-description\">Enter a unique name for the dictionary.</span>\n" +
    "\t\t\t\t\t<div id=\"xl-error\" ng-show=\"postError\" xl-widget-alert-message on-dismiss=\"postError=undefined\">{{ postError }}</div>\n" +
    "\t\t\t\t</div>\n" +
    "\n" +
    "\t\t\t\t<div class=\"map-dictionary\">\n" +
    "\t\t\t\t\t<div xl-dip-map-string-string ng-model=\"$tabData.newDictionary.entries\" metadata=\"{name: 'newDictionaryEntries', label: ''}\"\n" +
    "\t\t\t\t\t\t display-mode=\"$tabData.mode\"></div>\n" +
    "\t\t\t\t</div>\n" +
    "\t\t\t\t<div class=\"xl-button-container\">\n" +
    "\t\t\t\t\t<button type=\"button\" class=\"xl-button xl-primary\" ng-click=\"addDictionary()\"\n" +
    "\t\t\t\t\t\t\tng-disabled=\"!isValidDictionary()\">Add to environment</button>\n" +
    "\t\t\t\t</div>\n" +
    "\t\t\t</div>\n" +
    "\n" +
    "\t\t</div>\n" +
    "\t</div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/environment/select-existing-container/select-existing-container-modal.html',
    "<div class=\"xl-scrollable\">\n" +
    "    <div class=\"xl-form-wrapper\">\n" +
    "        <div xl-widget-item-selector handlers=\"existingContainersHandlers\" ng-model=\"selectedContainers\"\n" +
    "             options=\"{description: 'Select existing container:', multiple: false}\" obj-label=\"id\"\n" +
    "             empty-placeholder=\"No container of this type available\"></div>\n" +
    "\n" +
    "        <div class=\"xl-button-container\">\n" +
    "            <button ng-click=\"cancel()\" class=\"xl-button xl-cancel\">Cancel</button>\n" +
    "            <button ng-click=\"addContainer()\" class=\"xl-button xl-primary\"\n" +
    "                    ng-disabled=\"!hasSelectedContainer()\">Select container</button>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>"
  );


  $templateCache.put('web-src/environments/tabs/welcome/welcome.html',
    "<div class=\"content\" id=\"welcome-tab\">\n" +
    "\n" +
    "  <div class=\"xl-row\">\n" +
    "    <div class=\"xl-column-main\">\n" +
    "\n" +
    "      <div class=\"description\">\n" +
    "        <h4>XL Deploy Environments</h4>\n" +
    "\n" +
    "        <p>An environment is a group of infrastructure and middleware items such as hosts, application servers, web servers, and clusters.\n" +
    "          You use these items as targets when you deploy an application.</p>\n" +
    "\n" +
    "        <div class=\"question\">\n" +
    "          Would you like to create a new environment?\n" +
    "          <div id=\"new-environment\" class=\"xl-button xl-secondary button-welcome svg-icon icon_add_environment\"\n" +
    "               ng-click=\"newEnvironment('')\">\n" +
    "            Create environment\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div><!--\n" +
    "\n" +
    "---><div class=\"xl-column-aside\" xl-sticky-parent>\n" +
    "      <div class=\"xl-help-block\" xl-sticky>\n" +
    "        <h4>Help</h4>\n" +
    "\t\t\t<p>An environment is a group of infrastructure and middleware containers such as hosts, application servers, web servers, and clusters. You can use these containers as targets when you deploy an application.</p>\n" +
    "\t\t\t<p>You can store data that is specific to an environment (such as user names and file paths) in a dictionary. Dictionaries are sets of key-value pairs that XL Deploy uses to replace placeholders that you insert in your deployment packages.</p>\n" +
    "\t\t\t<p>To create a new environment, click Create environment.</p>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "\n" +
    "</div>"
  );

}]);
