angular.module('xl.online.commons', []);
'use strict';
angular.module('xl.online.commons').factory('ciService', [
  'constantService',
  'ciResource',
  'utils',
  function (constantService, ciResource, utils) {
    function ciExists(root, ciName) {
      var ci = utils.removeLeadingSlash(ciName);
      ci = utils.removeTrailingSlash(ci);
      ci = utils.addLeadingSlashIfNotExists(ci);
      return ciResource.ciExists(root + ci);
    }
    function createJsonCi(ciObj, type) {
      return {
        id: ciObj.id,
        type: type
      };
    }
    function createJsonCiWithData(ciObj, type, data) {
      var jsonCi = createJsonCi(ciObj, type);
      angular.extend(jsonCi, data);
      return jsonCi;
    }
    function extractCiStructure(ciId) {
      if (angular.isUndefined(ciId)) {
        return {
          root: undefined,
          name: undefined,
          path: undefined,
          id: undefined,
          idWithoutRoot: undefined
        };
      }
      var firstSlashIndex = ciId.indexOf('/');
      var root = ciId.substring(0, firstSlashIndex);
      var lastSlashIndex = ciId.lastIndexOf('/');
      var name = ciId.substring(lastSlashIndex + 1);
      var path = ciId.substring(firstSlashIndex, lastSlashIndex);
      path = path.charAt(0) === '/' ? path : '/' + path;
      path = path.length === 1 ? '' : path;
      return {
        root: root,
        name: name,
        path: path,
        id: root + path + '/' + name,
        idWithoutRoot: path + '/' + name
      };
    }
    function createDirectoriesJsonCis(ciObj) {
      var cis = [];
      var folderPrefix = '';
      var path = ciObj.path;
      if (path && path !== '') {
        path = utils.removeLeadingSlash(path);
        var folders = path.split('/');
        for (var i = 0; i < folders.length; i++) {
          var directoryObj = normalizeCiId(ciObj.root, folderPrefix, folders[i]);
          cis.push(createJsonCi(directoryObj, constantService.TYPE.CORE_DIRECTORY));
          folderPrefix += folders[i] + '/';
        }
      }
      return cis;
    }
    var normalizeCiId = function (root, path, name) {
      root = utils.removeLeadingSlash(root);
      root = utils.removeTrailingSlash(root);
      path = utils.addLeadingSlashIfNotExists(path);
      path = utils.removeTrailingSlash(path);
      name = utils.addLeadingSlashIfNotExists(name);
      name = utils.removeTrailingSlash(name);
      var data = {};
      data.name = name ? name : '';
      data.path = path ? path : '';
      data.root = root ? root : '';
      data.id = data.root + data.path + data.name;
      data.idWithoutRoot = data.path + data.name;
      return data;
    };
    function getCi(ciId) {
      return ciResource.get(ciId);
    }
    return {
      getCi: getCi,
      ciExists: ciExists,
      createJsonCi: createJsonCi,
      createJsonCiWithData: createJsonCiWithData,
      createDirectoriesJsonCis: createDirectoriesJsonCis,
      normalizeCiId: normalizeCiId,
      extractCiStructure: extractCiStructure
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('confirmDialogService', [
  '$xlModal',
  '$q',
  function ($xlModal, $q) {
    /**
     * @deprecated
     */
    var confirmDialog = function (cond, message, yesAction, cancelAction) {
      if (cond === false) {
        var modalInstance = $xlModal.open({
            templateUrl: 'web-src/common/confirm-dialog/confirm-dialog.html',
            windowClass: 'xl-confirm-modal',
            controller: [
              '$scope',
              '$xlModalInstance',
              function ($scope, $xlModalInstance) {
                $scope.message = message;
                $scope.yes = function () {
                  $xlModalInstance.close();
                };
                $scope.cancel = function () {
                  $xlModalInstance.dismiss('cancel');
                };
              }
            ]
          });
        modalInstance.result.then(function () {
          if (!!yesAction) {
            yesAction();
          }
        }, function () {
          if (!!cancelAction) {
            cancelAction();
          }
        });
      } else {
        if (!!yesAction) {
          yesAction();
        }
      }
    };
    /**
     * @cond condition to show dialog
     * @message confirmation message
     */
    var openConfirmDialog = function (cond, message) {
      if (cond === false) {
        return $xlModal.open({
          templateUrl: 'web-src/common/confirm-dialog/confirm-dialog.html',
          windowClass: 'xl-confirm-modal',
          controller: [
            '$scope',
            '$xlModalInstance',
            function ($scope, $xlModalInstance) {
              $scope.message = message;
              $scope.yes = function () {
                $xlModalInstance.close();
              };
              $scope.cancel = function () {
                $xlModalInstance.dismiss('cancel');
              };
            }
          ]
        }).result;
      } else {
        var deferred = $q.defer();
        deferred.resolve();
        return deferred.promise;
      }
    };
    return {
      confirmDialog: confirmDialog,
      openConfirmDialog: openConfirmDialog
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('constantService', function () {
  return {
    ROOT: {
      APPLICATIONS: 'Applications',
      ENVIRONMENTS: 'Environments',
      INFRASTRUCTURE: 'Infrastructure',
      CONFIGURATION: 'Configuration'
    },
    TYPE: {
      UDM_COMPOSITE_PACKAGE: 'udm.CompositePackage',
      UDM_DEPLOYMENT_PACKAGE: 'udm.DeploymentPackage',
      UDM_APPLICATIONS: 'udm.Application',
      CORE_DIRECTORY: 'core.Directory',
      UDM_ENVIRONMENT: 'udm.Environment',
      UDM_CONTAINER: 'udm.Container',
      UDM_DICTIONARY: 'udm.Dictionary',
      TRIGGER_TRIGGER: 'trigger.Trigger',
      UDM_DEPLOYABLE: 'udm.Deployable',
      UDM_VERSION: 'udm.Version'
    },
    MODES: {
      EDITION: 'edition',
      VIEW: 'visual',
      CREATION: 'creation'
    }
  };
});
'use strict';
angular.module('xl.online.commons').directive('dialogPopup', [function () {
    return {
      restrict: 'A',
      scope: { options: '=' },
      templateUrl: 'web-src/common/dialog/dialog.html',
      replace: true,
      controller: [
        '$scope',
        function (scope) {
        }
      ]
    };
  }]);
'use strict';
angular.module('xl.online.commons').factory('dipHandlers', [
  'ciResource',
  function (ciResource) {
    // Handlers
    function ciHandler(referencedType, term) {
      return ciResource.findAllCis(referencedType, term).then(function (response) {
        return _.map(response.data, function (item) {
          item.id = item.ref;
          delete item.ref;
          return item;
        });
      });
    }
    function ciFormHandler(metadata, options) {
      return ciHandler(metadata.referencedType, options.term);
    }
    return {
      formHandlers: {
        CI: { addCandidates: ciFormHandler },
        SET_OF_CI: { addCandidates: ciFormHandler },
        LIST_OF_CI: { addCandidates: ciFormHandler }
      },
      ciHandler: ciHandler
    };
  }
]);
'use strict';
angular.module('xl.online.commons').directive('onSingleClick', [
  '$parse',
  function ($parse) {
    return {
      restrict: 'A',
      link: function (scope, element, attr) {
        var fn = $parse(attr.onSingleClick);
        var delay = 300, clicks = 0, timer = null;
        element.on('click', function (event) {
          clicks++;
          //count clicks
          if (clicks === 1) {
            timer = setTimeout(function () {
              scope.$apply(function () {
                fn(scope, { $event: event });
              });
              clicks = 0;  //after action performed, reset counter
            }, delay);
          } else {
            clearTimeout(timer);
            //prevent single-click action
            clicks = 0;  //after action performed, reset counter
          }
        });
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').directive('xlStickyParent', function () {
  return {
    restrict: 'A',
    controller: [
      '$element',
      function ($element) {
        this.getWidth = function () {
          return $element.width();
        };
        this.isDisplayBlock = function () {
          return $element.css('display') === 'block';
        };
      }
    ]
  };
});
angular.module('xl.online.commons').directive('xlSticky', [
  '$window',
  function ($window) {
    return {
      require: '^xlStickyParent',
      restrict: 'A',
      link: function (scope, element, attrs, parentCtrl) {
        var position = element.css('position');
        function checkIfShouldStick() {
          if (parentCtrl.isDisplayBlock()) {
            element.css({
              position: position,
              width: 'auto'
            });
          } else {
            element.css({
              position: 'fixed',
              width: parentCtrl.getWidth()
            });
          }
        }
        angular.element($window).on('resize', function () {
          checkIfShouldStick();
        });
        checkIfShouldStick();
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('errorService', function () {
  var HTTP_STATUS = { INTERNAL_SERVER_ERROR: 500 };
  var isAnErrorCatched = function (error) {
    return error.status >= HTTP_STATUS.INTERNAL_SERVER_ERROR;
  };
  return { isAnErrorCatched: isAnErrorCatched };
});
'use strict';
angular.module('xl.online.commons').config([
  '$httpProvider',
  function ($httpProvider) {
    /**
     * Adding an additional params to every request to fix the cache issue on IE 8
     */
    $httpProvider.interceptors.push(function () {
      return {
        request: function (config) {
          if (config.method === 'GET') {
            if (config.params) {
              config.params.cacheBuster = new Date().getTime();
            } else {
              if (config.url.indexOf('.html') === -1) {
                config.params = { cacheBuster: new Date().getTime() };
              }
            }
          }
          return config;
        }
      };
    });
  }
]);
'use strict';
angular.module('xl.online.commons').config([
  '$httpProvider',
  function ($httpProvider) {
    $httpProvider.interceptors.push(function ($q, xlNotify) {
      return {
        'responseError': function (rejection) {
          if (rejection.status >= 500) {
            xlNotify.notify({
              message: rejection.data,
              title: rejection.statusText
            }, 'ERROR');
            rejection.xlPreventDefault = true;
          }
          return $q.reject(rejection);
        }
      };
    });
  }
]);
'use strict';
angular.module('xl.online.commons').factory('httpMultipartService', [
  '$http',
  '$q',
  '$rootScope',
  function ($http, $q, $rootScope) {
    var save = function (url, data) {
      var fd = new FormData();
      angular.forEach(data, function (value, key) {
        fd.append(key, value);
      });
      var deferred = $q.defer();
      $.ajax({
        url: url,
        type: 'POST',
        data: fd,
        contentType: false,
        processData: false,
        xhr: function () {
          var _xhr = $.ajaxSettings.xhr();
          if (_xhr.upload) {
            _xhr.upload.addEventListener('loadstart', function () {
              deferred.notify({ status: 'loadstart' });
            }, false);
            _xhr.upload.addEventListener('loadend', function () {
              deferred.notify({ status: 'loadend' });
            }, false);
            // onabort: onerror: onload ontimeout
            _xhr.upload.addEventListener('progress', function (evt) {
              if (evt.lengthComputable) {
                deferred.notify({
                  status: 'progress',
                  loaded: evt.loaded,
                  total: evt.total,
                  abort: function () {
                    _xhr.abort();
                  }
                });
              }
            }, false);
          }
          return _xhr;
        },
        complete: function (jqXHR, textStatus) {
          deferred.resolve(textStatus);
        },
        error: function (jqXHR, textStatus, errorThrown) {
          deferred.reject(errorThrown);
        },
        beforeSend: function (xhr) {
          if ($http.defaults.headers.common.Authorization) {
            xhr.setRequestHeader('Authorization', $http.defaults.headers.common.Authorization);
          }
        }
      });
      return deferred.promise;
    };
    return { save: save };
  }
]);
'use strict';
angular.module('xl.online.commons').config([
  '$httpProvider',
  function ($httpProvider) {
    var flexApp = parent.document.getElementById('flexApplication');
    if (flexApp) {
      $httpProvider.defaults.headers.common.Authorization = flexApp.getBasicAuth();
    }
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/json';
  }
]);
'use strict';
angular.module('xl.online.commons').factory('metadataResource', [
  '$http',
  'xlDeployServicesRoot',
  function ($http, xlDeployServicesRoot) {
    return {
      getTypesDescriptors: function () {
        return $http.get(xlDeployServicesRoot + 'metadata/type');
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('ciResource', [
  '$http',
  'xlDeployServicesRoot',
  'repositoryQueryBuilder',
  'httpMultipartService',
  function ($http, xlDeployServicesRoot, repositoryQueryBuilder, httpMultipartService) {
    return {
      get: function (ciId) {
        return $http.get(xlDeployServicesRoot + 'repository/ci/' + ciId);
      },
      saveAllCis: function (cis) {
        return $http.post(xlDeployServicesRoot + 'repository/cis', cis);
      },
      saveCi: function (ci) {
        return $http.post(xlDeployServicesRoot + 'repository/ci/' + ci.id, ci);
      },
      updateCi: function (ci) {
        return $http.put(xlDeployServicesRoot + 'repository/ci/' + ci.id, ci);
      },
      saveCiMultipart: function (ci, file) {
        var url = xlDeployServicesRoot + 'repository/ci/' + ci.id;
        return httpMultipartService.save(url, {
          fileData: file,
          filename: file.name,
          configurationItem: new Blob([JSON.stringify(ci)], { type: 'application/json' })
        });
      },
      findAllCis: function (type, namePattern) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType(type).withNamePattern(namePattern).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      },
      ciExists: function (ciName) {
        return $http.get(xlDeployServicesRoot + 'repository/exists/' + ciName);
      },
      editCi: function (ciName, ci) {
        return $http({
          url: xlDeployServicesRoot + 'repository/ci/' + ciName,
          dataType: 'json',
          method: 'PUT',
          data: ci,
          headers: {
            'Content-Type': 'application/json',
            'Accept-Type': 'application/json'
          }
        });
      },
      deleteCi: function (ciId) {
        return $http.delete(xlDeployServicesRoot + 'repository/ci/' + ciId);
      },
      findAllCisByAncestor: function (ancestorId) {
        var query = repositoryQueryBuilder.newQueryBuilder().withAncestor(ancestorId).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      },
      findAllCisByType: function (type, parentId) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType(type).withParent(parentId).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('directoryResource', [
  '$http',
  'xlDeployServicesRoot',
  'repositoryQueryBuilder',
  function ($http, xlDeployServicesRoot, repositoryQueryBuilder) {
    return {
      findAllDirectories: function (namePattern) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType('core.Directory').withNamePattern(namePattern).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      },
      findAllDirectoriesByParent: function (parentId, namePattern) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType('core.Directory').withNamePattern(namePattern).withParent(parentId).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      },
      findAllDirectoriesByAncestor: function (ancestorId, namePattern) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType('core.Directory').withNamePattern(namePattern).withAncestor(ancestorId).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('repositoryQueryBuilder', function () {
  var QueryBuilder = function () {
    var query = { params: { resultsPerPage: -1 } };
    this.withType = function (type) {
      if (type) {
        query.params.type = type;
      }
      return this;
    };
    this.withParent = function (parent) {
      if (parent) {
        query.params.parent = parent;
      }
      return this;
    };
    this.withAncestor = function (ancestor) {
      if (ancestor) {
        query.params.ancestor = ancestor;
      }
      return this;
    };
    this.withNamePattern = function (namePattern) {
      if (namePattern) {
        query.params.namePattern = '%' + namePattern + '%';
      }
      return this;
    };
    this.startingWithNamePattern = function (namePattern) {
      if (namePattern) {
        query.params.namePattern = namePattern + '%';
      }
      return this;
    };
    this.query = function () {
      return query;
    };
  };
  var newQueryBuilder = function () {
    return new QueryBuilder();
  };
  return { newQueryBuilder: newQueryBuilder };
});
'use strict';
angular.module('xl.online.commons').factory('versionResource', [
  '$http',
  'xlDeployServicesRoot',
  'repositoryQueryBuilder',
  function ($http, xlDeployServicesRoot, repositoryQueryBuilder) {
    return {
      findAllVersions: function (namePattern) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType('udm.DeploymentPackage').withNamePattern(namePattern).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      },
      findAllVersionsByParent: function (parentId) {
        var query = repositoryQueryBuilder.newQueryBuilder().withType('udm.Version').withParent(parentId).query();
        return $http.get(xlDeployServicesRoot + 'repository/query', query);
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').directive('scrollTo', function () {
  return {
    restrict: 'A',
    scope: { scrollToMe: '=' },
    link: function ($scope, $element) {
      if ($scope.scrollToMe) {
        angular.element('.content').animate({ scrollTop: $element.offset().top }, 100, 'linear');
        $scope.scrollToMe = false;
      }
    }
  };
});
'use strict';
angular.module('xl.online.commons').factory('treeService', function () {
  function completeCiArray(targetArray, updatingValues) {
    var existingLabels = _.pluck(targetArray, 'label');
    var retainedValues = _.reject(updatingValues, function (value) {
        return _.contains(existingLabels, value.label);
      });
    _.forIn(retainedValues, function (node) {
      targetArray.push(node);
    });
  }
  function sortCisByLabel(a, b) {
    return a.label < b.label ? -1 : a.label === b.label ? 0 : 1;
  }
  function unfoldNode(labelsToTargetNode, labelIdx, parentNode, selectCallback, findStructureByParent) {
    var currentDepthLabel = labelsToTargetNode[labelIdx];
    var matchingNodes = _.filter(parentNode.children, function (node) {
        return node.label === currentDepthLabel;
      });
    if (matchingNodes.length > 1) {
      throw new Error('there should not be duplicated node names with the same parent node');
    } else if (matchingNodes.length === 1) {
      // there is a single matching node already loaded: we open it
      var node = matchingNodes[0];
      if (labelIdx === labelsToTargetNode.length - 1) {
        // we just found the target node to select
        node.from = 'create';
        selectCallback(node);
      } else if (node.children && node.children.length > 0) {
        node.open = true;
        if (labelIdx + 1 < labelsToTargetNode.length) {
          unfoldNode(labelsToTargetNode, labelIdx + 1, node, selectCallback, findStructureByParent);
        }
      } else {
        // we load the node's children
        findStructureByParent(node.path, node.classType).then(function (childrenNodes) {
          if (childrenNodes && childrenNodes.length > 0) {
            if (!node.children) {
              node.children = [];
            }
            completeCiArray(node.children, childrenNodes);
            node.children.sort(sortCisByLabel);
            node.open = true;
            if (labelIdx + 1 < labelsToTargetNode.length) {
              unfoldNode(labelsToTargetNode, labelIdx + 1, node, selectCallback, findStructureByParent);
            }
          }
        });
      }
    } else {
      // no matching node: we should reload the all the direct children of the parent node
      findStructureByParent(parentNode.path, parentNode.classType).then(function (childrenNodes) {
        if (childrenNodes && childrenNodes.length > 0) {
          if (angular.equals(parentNode.children, childrenNodes)) {
            throw new Error('even after refreshing the children nodes of a parent, no matching path could be found');
          }
          completeCiArray(parentNode.children, childrenNodes);
          parentNode.children.sort(sortCisByLabel);
          unfoldNode(labelsToTargetNode, labelIdx, parentNode, selectCallback, findStructureByParent);
        } else {
          throw new Error('even after refreshing the children nodes of a parent, no matching path could be found');
        }
      });
    }
  }
  function removeNode(ids, nodes) {
    function removeNodeInner(nodes, index) {
      var id = ids[index];
      if (index === ids.length - 1) {
        _.remove(nodes, { label: id });
      } else {
        var node = _.find(nodes, { label: id });
        var children = node !== undefined ? node.children : false;
        removeNodeInner(children, index + 1);
      }
    }
    if (ids && ids.length > 0) {
      removeNodeInner(nodes, 0);
    }
  }
  return {
    unfoldNode: unfoldNode,
    removeNode: removeNode
  };
});
'use strict';
angular.module('xl.online.commons').directive('treeView', [function ($state) {
    return {
      restrict: 'A',
      scope: {
        options: '=',
        currentNode: '=',
        nodes: '=',
        datasource: '='
      },
      template: '<div><div tree-nodes="nodes" id="treeViewRoot" ></div></div>',
      controller: [
        '$scope',
        '$state',
        function (scope, state) {
          this.isNodeSelected = function (node) {
            return node.path === scope.currentNode.path;
          };
          var selectNode = function (selectedNode) {
            scope.currentNode.path = selectedNode.path;
          };
          this.selectNodeHead = function (selectedNode, $event) {
            $event.stopPropagation();
            //Collapse or Expand
            selectedNode.open = !selectedNode.open;
            if (!selectedNode.children || selectedNode.children.length === 0) {
              scope.datasource(selectedNode).then(function (childrenNodes) {
                selectedNode.children = childrenNodes;
              });
            }
          };
          //if node label clicks,
          this.selectNodeLabel = function (selectedNode) {
            //remove highlight from previous node
            if (scope.currentNode && scope.currentNode.selected) {
              delete scope.currentNode.selected;
            }
            //set highlight to selected node
            selectNode(selectedNode);
            scope.options.clickAction(selectedNode);
          };
          this.dblClickAction = function (selectedNode) {
            selectNode(selectedNode);
            scope.options.dblClickAction(selectedNode);
          };
        }
      ]
    };
  }]).directive('treeNodes', [
  '$compile',
  function ($compile) {
    return {
      restrict: 'A',
      scope: { treeNodes: '=' },
      templateUrl: 'web-src/common/tree/tree-nodes.html',
      require: '^treeView',
      compile: function (el) {
        var contents = el.contents().remove();
        var compiled;
        return function (scope, el, attr, ctrl) {
          if (!compiled) {
            compiled = $compile(contents);
          }
          compiled(scope, function (clone) {
            el.append(clone);
          });
          scope.selectNodeHead = ctrl.selectNodeHead;
          scope.selectNodeLabel = ctrl.selectNodeLabel;
          scope.dblClickAction = ctrl.dblClickAction;
          scope.isNodeSelected = ctrl.isNodeSelected;
          scope.hasChildren = function (node) {
            if (node.children) {
              return true;
            }
            return false;
          };
        };
      }
    };
  }
]);
'use strict';
angular.module('xl.online.commons').factory('typeSystemService', [
  '$q',
  'constantService',
  'metadataResource',
  function ($q, constantService, metadataResource) {
    var typesDescriptors = {};
    var deployableTypes = [];
    var deployableTypesNames = [];
    // TODO delete if not used
    var containerTypesNames = [];
    var groupedByDeployableType = {};
    var groupedBySuperType = {};
    var loadTypesDescriptors = function () {
      var deferred = $q.defer();
      metadataResource.getTypesDescriptors().then(function (descriptors) {
        deployableTypesNames.length = 0;
        _.forEach(descriptors.data, function (metadata) {
          typesDescriptors[metadata.type] = metadata;
          _.forEach(metadata.superTypes, function (superType) {
            if (angular.isUndefined(groupedBySuperType[superType])) {
              groupedBySuperType[superType] = [];
            }
            groupedBySuperType[superType].push(metadata);
          });
          if (_.contains(metadata.interfaces, constantService.TYPE.UDM_DEPLOYABLE)) {
            deployableTypesNames.push(metadata.type);
            deployableTypes.push(metadata);
          }
          if (_.contains(metadata.interfaces, constantService.TYPE.UDM_CONTAINER)) {
            containerTypesNames.push(metadata.type);
          }
        });
        groupedByDeployableType = _.groupBy(descriptors.data, 'deployableType');
        // sort deployableTypes
        deployableTypes = _.sortBy(deployableTypes, 'type');
        containerTypesNames = _.sortBy(containerTypesNames);
        deferred.resolve();
      }, function (error) {
        deferred.reject(error);
      });
      return deferred.promise;
    };
    var getTypesByDeployableType = function (deployableType) {
      return groupedByDeployableType[deployableType];
    };
    var getContainerTypeNames = function () {
      return containerTypesNames;
    };
    var getDeployableTypeNames = function () {
      return deployableTypesNames;
    };
    var getDeployableTypes = function () {
      return deployableTypes;
    };
    var getTypeDescriptorOf = function (type) {
      return typesDescriptors[type];
    };
    var getTypeDescriptorOfSuperType = function (superType) {
      return groupedBySuperType[superType];
    };
    var isSourceArtifactType = function (type) {
      return _.contains(typesDescriptors[type].interfaces, 'udm.SourceArtifact');
    };
    return {
      loadTypesDescriptors: loadTypesDescriptors,
      getTypeDescriptorOf: getTypeDescriptorOf,
      getDeployableTypeNames: getDeployableTypeNames,
      getContainerTypeNames: getContainerTypeNames,
      getTypesByDeployableType: getTypesByDeployableType,
      getDeployableTypes: getDeployableTypes,
      getTypeDescriptorOfSuperType: getTypeDescriptorOfSuperType,
      isSourceArtifactType: isSourceArtifactType
    };
  }
]);
'use strict';
var localeId = 'en-us';
if (navigator.userLanguage) {
  // Explorer
  localeId = navigator.userLanguage;
} else if (navigator.language) {
  // FF
  localeId = navigator.language;
}
/* jshint ignore:start */
if (localeId) {
  document.write('<script src="dist/libs/i18n/angular-locale_' + localeId.toLocaleLowerCase() + '.js"></script>');
}
/* jshint ignore:end */
'use strict';
angular.module('xl.online.commons').factory('utils', function () {
  var removePrefix = function (id) {
    if (angular.isUndefined(id)) {
      return id;
    }
    var index = id.indexOf('/');
    if (index === 0) {
      index = id.indexOf('/', 1);
      index = index === -1 ? 0 : index;
    }
    return index === -1 ? id : id.substr(index + 1);
  };
  var removeLeadingSlash = function (inputString) {
    return inputString && inputString.replace(/^\//, '');
  };
  var removeTrailingSlash = function (inputString) {
    return inputString && inputString.replace(/\/$/, '');
  };
  var addLeadingSlashIfNotExists = function (inputString) {
    if (angular.isDefined(inputString) && inputString.length !== 0 && inputString.indexOf('/') !== 0) {
      return '/' + inputString;
    }
    return inputString;
  };
  var getCiIdsWithoutPrefix = function (response) {
    return _.map(response.data, function (ci) {
      return removePrefix(ci.ref);
    });
  };
  // API
  return {
    removePrefix: removePrefix,
    removeLeadingSlash: removeLeadingSlash,
    removeTrailingSlash: removeTrailingSlash,
    addLeadingSlashIfNotExists: addLeadingSlashIfNotExists,
    getCiIdsWithoutPrefix: getCiIdsWithoutPrefix
  };
});