/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.maven.AbstractDeployitMojo;
import com.xebialabs.deployit.maven.MavenContainer;
import com.xebialabs.deployit.maven.helper.DeploymentHelper;
import com.xebialabs.deployit.maven.logic.CustomDeployedsApplicationStrategy;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DeployMojo
extends AbstractDeployitMojo {
    private String currentVersion;
    private Deployment generatedDeployment;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"xldeploy:deploy");
        this.boot();
        try {
            this.deploy();
        }
        finally {
            this.shutdown();
        }
        this.getLog().info((CharSequence)"End of xldeploy:deploy");
    }

    private void deploy() throws MojoExecutionException {
        ConfigurationItem deploymentPackage = this.uploadPackage();
        ConfigurationItem targetEnvironment = this.getTargetEnvironment();
        Boolean update = this.getDeploymentHelper().isApplicationDeployed(deploymentPackage.getId(), targetEnvironment.getId());
        this.generateDeployment(deploymentPackage, targetEnvironment, update);
        this.getLog().info((CharSequence)"Deployeds to be included into generatedDeployment:");
        for (ConfigurationItem d : this.generatedDeployment.getDeployeds()) {
            this.getLog().info((CharSequence)("    -> " + d.getId()));
        }
        if (!Strings.isNullOrEmpty((String)this.orchestrator)) {
            this.getLog().info((CharSequence)("Using orchestrator: " + this.orchestrator));
            this.generatedDeployment.getDeployedApplication().setProperty("orchestrator", (Object)this.orchestrator);
        }
        String taskId = this.generateDeploymentTask();
        if (this.testMode) {
            this.getLog().info((CharSequence)" ... Test mode discovered => displaying and cancelling the generated task");
            this.getDeploymentHelper().logTaskState(taskId);
            this.communicator.getProxies().getTaskService().cancel(taskId);
            return;
        }
        this.runDeploymentTask(taskId);
        if (this.deletePreviouslyDeployedDar && update.booleanValue() && this.currentVersion != null) {
            this.getLog().info((CharSequence)("removing the previous version " + this.currentVersion));
            try {
                this.communicator.getProxies().getRepositoryService().delete(this.currentVersion);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Cannot delete " + this.currentVersion + ": " + e.getMessage()));
            }
        }
    }

    private ConfigurationItem uploadPackage() {
        ConfigurationItem deploymentPackage = this.getDeploymentHelper().uploadPackage(this.getPackager().perform());
        this.getLog().info((CharSequence)String.format("Application ['%s'] has been imported", deploymentPackage.getId()));
        return deploymentPackage;
    }

    private ConfigurationItem getTargetEnvironment() throws MojoExecutionException {
        if (Strings.emptyToNull((String)this.environmentId) == null && (this.environment == null || this.environment.isEmpty())) {
            throw new MojoExecutionException("Mandatory parameter environmentId is not set");
        }
        ConfigurationItem targetEnvironment = this.getDeploymentHelper().readCiOrNull(this.environmentId);
        if (targetEnvironment == null) {
            targetEnvironment = this.createTargetEnvironment();
        }
        this.getDeploymentHelper().logEnvironment(targetEnvironment);
        return targetEnvironment;
    }

    private void runDeploymentTask(String taskId) throws MojoExecutionException {
        if (this.skipMode) {
            this.getLog().info((CharSequence)" ... Skip mode discovered");
            this.getDeploymentHelper().skipAllSteps(taskId);
        }
        this.getLog().info((CharSequence)"Executing generatedDeployment task");
        try {
            TaskExecutionState taskExecutionState = this.getDeploymentHelper().executeAndArchiveTask(taskId);
            if (taskExecutionState.isExecutionHalted()) {
                throw new MojoExecutionException(String.format("Errors when executing task %s. Read logs above to find exact reason.", taskId));
            }
        }
        catch (IllegalStateException e) {
            if (this.cancelTaskOnError) {
                this.getLog().info((CharSequence)("cancel task on error " + taskId));
                this.communicator.getProxies().getTaskService().cancel(taskId);
            }
            throw e;
        }
    }

    private String generateDeploymentTask() throws MojoExecutionException {
        String taskId;
        this.getLog().info((CharSequence)"Creating a task");
        try {
            taskId = this.communicator.getProxies().getDeploymentService().createTask(this.getDeploymentHelper().validateDeployment(this.generatedDeployment));
        }
        catch (DeploymentHelper.DeploymentValidationError validationError) {
            for (ValidationMessage validationMessage : validationError.getValidationMessages()) {
                this.getLog().error((CharSequence)validationMessage.toString());
            }
            throw new RuntimeException(validationError);
        }
        this.getLog().info((CharSequence)("    -> task id: " + taskId));
        return taskId;
    }

    private void generateDeployment(ConfigurationItem deploymentPackage, ConfigurationItem targetEnvironment, Boolean update) {
        DeploymentService deploymentService = this.communicator.getProxies().getDeploymentService();
        RepositoryService repositoryService = this.communicator.getProxies().getRepositoryService();
        if (update.booleanValue()) {
            this.getLog().info((CharSequence)" ... Application already exists => preparing update");
            this.generatedDeployment = deploymentService.prepareUpdate(deploymentPackage.getId(), this.getDeployedApplicationId(deploymentPackage.getId(), targetEnvironment.getId()));
            this.currentVersion = (String)repositoryService.read(this.getDeployedApplicationId(deploymentPackage.getId(), targetEnvironment.getId())).getProperty("version");
            if (this.generateDeployedOnUpgrade && !this.hasDeployeds()) {
                this.generatedDeployment = deploymentService.prepareAutoDeployeds(this.generatedDeployment);
            }
        } else {
            this.getLog().info((CharSequence)" ... Application not found in deployed => preparing for initial deployment");
            this.generatedDeployment = deploymentService.prepareInitial(deploymentPackage.getId(), targetEnvironment.getId());
            this.generatedDeployment = deploymentService.prepareAutoDeployeds(this.generatedDeployment);
        }
        if (this.deployeds != null && this.deployeds.size() > 0) {
            this.getLog().debug((CharSequence)"Updating generated deployeds with the configured deployeds");
            this.generatedDeployment = new CustomDeployedsApplicationStrategy().merge(this.generatedDeployment, this.deployeds);
        }
        if (this.explicitDeployeds) {
            this.generatedDeployment = this.getDeploymentHelper().attachExplicitDeployeds(this.generatedDeployment, this.deployeds);
        }
    }

    private ConfigurationItem createTargetEnvironment() throws MojoExecutionException {
        ConfigurationItem targetEnvironment;
        if (this.environment == null || this.environment.isEmpty()) {
            throw new MojoExecutionException("Environment does not exist and there are no members specified to create it.");
        }
        List members = Lists.transform(this.environment, (Function)new Function<MavenContainer, ConfigurationItem>(){

            public ConfigurationItem apply(MavenContainer input) {
                return input.asConfigurationItem();
            }
        });
        try {
            targetEnvironment = this.getDeploymentHelper().createEnvironment(this.environmentId, members);
        }
        catch (DeploymentHelper.EnvironmentAlreadyExistsError e) {
            throw new RuntimeException(e);
        }
        return targetEnvironment;
    }

    private String getDeployedApplicationId(String source, String target) {
        ArrayList splitSource = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)source));
        String appName = (String)splitSource.get(splitSource.size() - 2);
        return Joiner.on((String)"/").join((Object)target, (Object)appName, new Object[0]);
    }
}

