/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.maven.helper.IdHelper;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class ArtifactRepository {
    private Multimap<String, Artifact> repository = HashMultimap.create();

    public ArtifactRepository(MavenProject project) {
        Artifact projectArtifact;
        Set dependencyArtifacts = project.getArtifacts();
        if (dependencyArtifacts != null) {
            for (Artifact artifact : dependencyArtifacts) {
                this.repository.put((Object)IdHelper.generateId(artifact.getGroupId(), artifact.getArtifactId()), (Object)artifact);
            }
        }
        if ((projectArtifact = project.getArtifact()) != null) {
            this.repository.put((Object)IdHelper.generateId(projectArtifact.getGroupId(), projectArtifact.getArtifactId()), (Object)projectArtifact);
        }
    }

    public Artifact findSingleArtifact(String groupId, String artifactId, String type, String classifier) {
        String requestedId = IdHelper.generateId(groupId, artifactId);
        String fullId = IdHelper.generateId(groupId, artifactId, classifier, type);
        Collection candidates = this.repository.get((Object)requestedId);
        Artifact winner = null;
        for (Artifact candidate : candidates) {
            if (!this.equalsOrNotSpecified(classifier, candidate.getClassifier()) || !this.equalsOrNotSpecified(type, candidate.getType())) continue;
            Preconditions.checkState((winner == null ? 1 : 0) != 0, (Object)String.format("There are more artifacts that correspond to %s. Please be more specific by adding artifactType, classifier to your reference", fullId));
            winner = candidate;
        }
        Preconditions.checkState((winner != null ? 1 : 0) != 0, (Object)String.format("There is no artifact found that matches %s", fullId));
        return winner;
    }

    private boolean equalsOrNotSpecified(String predicate, String candidateValue) {
        return Strings.isNullOrEmpty((String)predicate) || predicate.equals(candidateValue);
    }
}

