/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.pr;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.transform.aggregators.Aggregator;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.Other;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.PullRequestUM;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.Relations;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OthersAggregator
implements Aggregator<PullRequestUM, PullRequest> {
    private String team;
    private String repo;

    public OthersAggregator(String team, String repo) {
        this.team = team;
        this.repo = repo;
    }

    @Override
    public void populate(PullRequestUM pullRequestUM, PullRequest pullRequest) {
        if (pullRequestUM.getOther() == null) {
            pullRequestUM.setOther(new Other());
        }
        Other other = pullRequestUM.getOther();
        other.setRelations(this.relations(pullRequest));
        other.setCommits(this.noOfCommits(pullRequest));
        other.setComments(this.noOfComments(pullRequest));
        other.setDescription(pullRequest.getDescription());
        other.setCreatedBy(pullRequest.getAuthor().getDisplayName());
        other.setMergedBy(this.mergedBy(pullRequest));
        other.setRaw(pullRequest);
    }

    private String mergedBy(PullRequest pullRequest) {
        if (pullRequest.getClosedBy() != null) {
            return pullRequest.getClosedBy().getDisplayName();
        }
        return null;
    }

    private int noOfCommits(PullRequest pullRequest) {
        List<String> commitIds = this.commitIds(pullRequest);
        return commitIds == null || commitIds.isEmpty() ? 0 : commitIds.size();
    }

    private int noOfComments(PullRequest pullRequest) {
        return pullRequest.getCommentCount();
    }

    private Relations relations(PullRequest pullRequest) {
        Relations relations = new Relations();
        HashMap<String, Object> commitsMap = new HashMap<String, Object>();
        List<String> commitIds = this.commitIds(pullRequest);
        commitsMap.put("to", commitIds);
        relations.setCommits(commitsMap);
        relations.setLastCommitId(this.lastCommitId(pullRequest));
        relations.setMergeCommitId(this.mergeCommitId(pullRequest));
        return relations;
    }

    private String lastCommitId(PullRequest pullRequest) {
        return this.generateId(pullRequest.getDestination().getCommit().getHash());
    }

    private String mergeCommitId(PullRequest pullRequest) {
        if (pullRequest.getMergeCommit() != null) {
            return pullRequest.getMergeCommit().getHash();
        }
        return null;
    }

    private List<String> commitIds(PullRequest pullRequest) {
        if (pullRequest.getCommits() == null || pullRequest.getCommits().isEmpty()) {
            return null;
        }
        return pullRequest.getCommits().stream().map(commit -> this.generateId(commit.getHash())).collect(Collectors.toList());
    }

    private String generateId(String id) {
        return id == null ? null : BitbucketUtil.generateDataId(this.team, this.repo, id);
    }
}

