/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucket.models.LinkedEntity;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.CommitResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCommitsCrawl
extends BitbucketBaseCrawl<BitbucketCommitsJobMessage, CommitResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketCommitsCrawl.class);

    public BitbucketCommitsCrawl(BitbucketCrawler crawler, BitbucketCommitsJobMessage message, BaseCrawlerMessage crawlerDataMessage) {
        super(crawler, message, crawlerDataMessage);
    }

    @Override
    protected CrawledDataWrappedResponse<CommitResponse> processBitbucketMessage() throws CrawlerWorkException {
        URL crawlUrl = ((BitbucketCommitsJobMessage)this.message).crawlUrl();
        logger.debug("Process BitbucketCommitsJobMessage for Team - {}, Rep - {} , URL - ", new Object[]{((BitbucketCommitsJobMessage)this.message).getTeamName(), ((BitbucketCommitsJobMessage)this.message).getRepoName(), crawlUrl});
        CrawledDataWrappedResponse crawledDataWrappedResponse = this.responseFetcher.fetch(CommitResponse.class, crawlUrl);
        this.handleResponse((CommitResponse)((Object)crawledDataWrappedResponse.getEntity()));
        return crawledDataWrappedResponse;
    }

    private void handleResponse(CommitResponse response) throws CrawlerWorkException {
        Map<String, String> filteredCommits = response.getValues().stream().filter(c -> c.isDateAfter(((BitbucketCrawler)this.crawler).getOldestValidDate())).collect(Collectors.toMap(Commit::getHash, LinkedEntity::fetchUrl));
        this.sendCommitDepthJobMessages((BitbucketRepoJobMessage)this.message, filteredCommits);
    }
}

