/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.components.BitbucketConstants;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.CollectionResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.CommitsCache;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerDelayWorkException;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.BaseCrawlService;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitbucketBaseCrawl<T extends BitbucketJobMessage, R>
extends BaseCrawlService<BitbucketCrawler, T, R> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketBaseCrawl.class);
    protected String nextURL = null;

    public BitbucketBaseCrawl(BitbucketCrawler crawler, T message, BaseCrawlerMessage dataMessage) {
        super((AbstractHttpCrawler)crawler, message, dataMessage);
    }

    protected CrawledDataWrappedResponse<R> processMessage() throws CrawlerWorkException {
        try {
            CollectionResponse collectionResponse;
            CrawledDataWrappedResponse<R> response = this.processBitbucketMessage();
            if (this instanceof Paginated && response.getEntity() instanceof CollectionResponse && (collectionResponse = (CollectionResponse)((Object)response.getEntity())).hasNext()) {
                this.nextURL = collectionResponse.getNext();
            }
            return response;
        }
        catch (CrawlerWorkException e) {
            if (BitbucketConstants.isRateLimitException((Exception)((Object)e))) {
                throw new CrawlerDelayWorkException((Throwable)e);
            }
            throw e;
        }
    }

    protected abstract CrawledDataWrappedResponse<R> processBitbucketMessage() throws CrawlerWorkException;

    void crawlCommitMessage(BitbucketRepoJobMessage bitbucketRepoJobMessage, String allCommitsUrl, Map.Entry<String, String> commit) throws CrawlerWorkException {
        if (bitbucketRepoJobMessage.getMetadata().isIncremental()) {
            this.sendSingleCommitMessage(bitbucketRepoJobMessage, commit);
        } else {
            this.sendCommitsJobMessage(bitbucketRepoJobMessage, allCommitsUrl);
        }
    }

    private void sendCommitsJobMessage(BitbucketRepoJobMessage bitbucketRepoJobMessage, String allCommitsUrl) throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketCommitsJobMessage.class, bitbucketRepoJobMessage).setEntityUrl(allCommitsUrl);
            ((BitbucketCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(BitbucketCommitsJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    protected void sendSingleCommitMessage(BitbucketRepoJobMessage bitbucketRepoJobMessage, Map.Entry<String, String> commit) throws CrawlerWorkException {
        if (CommitsCache.isCommitAlreadyRequested(bitbucketRepoJobMessage.getTeamName(), bitbucketRepoJobMessage.getRepoName(), commit.getKey())) {
            return;
        }
        CommitsCache.addRequestedCommit(bitbucketRepoJobMessage.getTeamName(), bitbucketRepoJobMessage.getRepoName(), commit.getKey());
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketCommitJobMessage.class, bitbucketRepoJobMessage).setCommitHash(commit.getKey()).setUrl(commit.getValue());
            ((BitbucketCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(BitbucketCommitJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    protected void sendCommitDepthJobMessages(BitbucketRepoJobMessage repoMessage, Map<String, String> commits) throws CrawlerWorkException {
        logger.debug("Send Commit {} messages in team - {}, repo - {}", new Object[]{commits.size(), repoMessage.getTeamName(), repoMessage.getRepoName()});
        for (Map.Entry<String, String> commit : commits.entrySet()) {
            this.sendSingleCommitMessage(repoMessage, commit);
        }
    }

    protected boolean isValidCommit(Commit c) {
        return c.isDateAfter(((BitbucketCrawler)this.crawler).getOldestValidDate());
    }
}

