/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucket.models.LinkedEntity;
import com.xebialabs.agatha.crawlers.bitbucket.models.Sha;
import com.xebialabs.agatha.crawlers.bitbucket.repository.CommitRepository;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.transform.converters.CommitConverter;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.CommitUM;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCommitCrawl
extends BitbucketBaseCrawl<BitbucketCommitJobMessage, Commit> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketCommitCrawl.class);
    private final UMConverter<CommitUM, Commit> converter;
    private final KeyValueRepository<CommitUM> repository;

    public BitbucketCommitCrawl(BitbucketCrawler crawler, BitbucketCommitJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.converter = new CommitConverter("BitbucketCloudPlugin", "v1", "COMMIT", "v1").setTeam(message.getTeamName()).setRepo(message.getRepoName());
        this.repository = new CommitRepository(crawler, dataMessage);
    }

    protected boolean isValid() {
        return ((BitbucketCrawler)this.crawler).decideToContinueBeforeCrawling(this.dataMessage, ((BitbucketCommitJobMessage)this.message).getCommitHash(), BitbucketUtil.generateDataId(((BitbucketCommitJobMessage)this.message).getTeamName(), ((BitbucketCommitJobMessage)this.message).getRepoName(), ((BitbucketCommitJobMessage)this.message).getCommitHash()), DataSourceTypeEnum.COMMIT);
    }

    @Override
    protected CrawledDataWrappedResponse<Commit> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketCommitJobMessage for endpoint {}, commit - {}, - team {}, repo - {} ", new Object[]{((BitbucketCommitJobMessage)this.message).getBaseUrl(), ((BitbucketCommitJobMessage)this.message).getCommitHash(), ((BitbucketCommitJobMessage)this.message).getTeamName(), ((BitbucketCommitJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(Commit.class, ((BitbucketCommitJobMessage)this.message).crawlUrl());
        this.handleResponse((Commit)response.getEntity());
        return response;
    }

    private void handleResponse(Commit commit) throws CrawlerWorkException {
        if (!this.isValidCommit(commit)) {
            return;
        }
        logger.debug("Saving commit {} in team - {}, repo - {}", new Object[]{commit.getHash(), ((BitbucketCommitJobMessage)this.message).getTeamName(), ((BitbucketCommitJobMessage)this.message).getRepoName()});
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)commit);
        boolean crawlParents = this.repository.save(umWrappedEntity);
        if (crawlParents) {
            logger.debug("Pushing {} parent commit depth jobs from commit {}", (Object)commit.getParents().size(), (Object)commit.getHash());
            this.sendCommitDepthJobMessages((BitbucketRepoJobMessage)this.message, commit.getParents().stream().collect(Collectors.toMap(Sha::getHash, LinkedEntity::fetchUrl)));
        }
    }
}

