/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.components;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketBranchJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketCommitsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTagJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTagsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketTeamJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBranchCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketCommitCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketCommitsCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketJobCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketPRCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketPRsCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketTagCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketTagsCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketTeamCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.BaseCrawlFactory;
import com.xebialabs.agatha.crawlers.shared.components.CrawlService;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.io.IOException;

public class BitbucketCrawlFactory
extends BaseCrawlFactory<BitbucketCrawler> {
    private CrawlService jobCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketJobCrawl(crawler, (BitbucketJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService teamCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketTeamCrawl(crawler, (BitbucketTeamJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketTeamJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService branchCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketBranchCrawl(crawler, (BitbucketBranchJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketBranchJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService prsCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketPRsCrawl(crawler, (BitbucketPRsJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketPRsJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService prCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketPRCrawl(crawler, (BitbucketPRJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketPRJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService commitsCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketCommitsCrawl(crawler, (BitbucketCommitsJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketCommitsJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService commitCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketCommitCrawl(crawler, (BitbucketCommitJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketCommitJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService tagsCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketTagsCrawl(crawler, (BitbucketTagsJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketTagsJobMessage.class)), crawlerDataMessage);
    }

    private CrawlService tagCrawl(BitbucketCrawler crawler, BaseCrawlerMessage crawlerDataMessage) throws IOException {
        return new BitbucketTagCrawl(crawler, (BitbucketTagJobMessage)((Object)this.deserialize(crawler.getMapper(), crawlerDataMessage, BitbucketTagJobMessage.class)), crawlerDataMessage);
    }

    public CrawlService getInstance(BitbucketCrawler crawler, BaseCrawlerMessage message) throws CrawlerWorkException {
        CrawlService crawlService;
        try {
            switch (message.getDataKey().toLowerCase()) {
                case "bitbucketjobmessage": {
                    crawlService = this.jobCrawl(crawler, message);
                    break;
                }
                case "bitbucketteamjobmessage": {
                    crawlService = this.teamCrawl(crawler, message);
                    break;
                }
                case "bitbucketbranchjobmessage": {
                    crawlService = this.branchCrawl(crawler, message);
                    break;
                }
                case "bitbucketprsjobmessage": {
                    crawlService = this.prsCrawl(crawler, message);
                    break;
                }
                case "bitbucketprjobmessage": {
                    crawlService = this.prCrawl(crawler, message);
                    break;
                }
                case "bitbucketcommitsjobmessage": {
                    crawlService = this.commitsCrawl(crawler, message);
                    break;
                }
                case "bitbucketcommitjobmessage": {
                    crawlService = this.commitCrawl(crawler, message);
                    break;
                }
                case "bitbuckettagsjobmessage": {
                    crawlService = this.tagsCrawl(crawler, message);
                    break;
                }
                case "bitbuckettagjobmessage": {
                    crawlService = this.tagCrawl(crawler, message);
                    break;
                }
                default: {
                    throw new CrawlerWorkException("No Crawler implementation found.");
                }
            }
        }
        catch (IOException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
        return crawlService;
    }
}

