/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.components.prAggregators;

import com.xebialabs.agatha.crawlers.AbstractHttpCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUrlHelper;
import com.xebialabs.agatha.crawlers.bitbucket.components.prAggregators.PRDataAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.CommitResponse;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.components.ResponseFetcher;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;

public class PRCommitsAggregator
implements PRDataAggregator {
    private final BitbucketPRJobMessage message;
    private final ResponseFetcher<BitbucketCrawler> responseFetcher;

    public PRCommitsAggregator(BitbucketPRJobMessage message, BitbucketCrawler crawler) {
        this.message = message;
        this.responseFetcher = new ResponseFetcher((AbstractHttpCrawler)crawler);
    }

    @Override
    public void populate(PullRequest pullRequest) throws CrawlerWorkException {
        pullRequest.setCommits(this.getCommits(pullRequest));
    }

    private List<Commit> getCommits(PullRequest pr) throws CrawlerWorkException {
        CrawledDataWrappedResponse response;
        URL url = BitbucketUrlHelper.prDataURL(pr.linkFor("commits"), 30);
        ArrayList<Commit> commits = new ArrayList<Commit>();
        while (!this.isEmpty(response = this.responseFetcher.fetchEntity(CommitResponse.class, url))) {
            commits.addAll(((CommitResponse)((Object)response.getEntity())).getValues());
            if (!((CommitResponse)((Object)response.getEntity())).hasNext()) break;
            url = HttpUrl.parse((String)((CommitResponse)((Object)response.getEntity())).getNext()).url();
            if (!this.isEmpty(response)) continue;
        }
        return commits;
    }
}

