/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.shared.utils;

import com.xebialabs.agatha.AgathaConfiguration;
import java.util.function.BiFunction;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProbeUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProbeUtils.class);

    public static StringBuilder getRequestHeadersAndCurl(Request request) {
        return new StringBuilder().append("REQUEST HEADERS:\n").append(ProbeUtils.filterAndFormatHeaders(request.headers(), (k, v) -> String.format("%s: %s\n", k, v))).append("\nDO NOT FORGET TO FIX AUTHORIZATION HEADER\n").append(ProbeUtils.curlProbeSample(request)).append("\n");
    }

    private static String curlProbeSample(Request request) {
        Headers responseHeaders = request.headers();
        return String.format("curl %s -X %s %s '%s'", AgathaConfiguration.isSelfSignedCertsTrustedWhileCrawling() ? "-k" : "", request.method(), ProbeUtils.filterAndFormatHeaders(responseHeaders, (k, v) -> String.format("-H '%s: %s' ", k, v)), request.url());
    }

    public static BasicProbeResult basicProbe(Request request, OkHttpClient client) {
        StringBuilder commentBuilder = new StringBuilder("url: " + request.url() + "\n");
        Call call = client.newCall(request);
        try {
            request = call.request();
            Response response = call.execute();
            commentBuilder.append((CharSequence)ProbeUtils.getRequestHeadersAndCurl(response.request()));
            commentBuilder.append("CODE: ").append(response.code()).append("\n");
            commentBuilder.append("\n\nRESPONSE HEADERS:\n");
            for (String header : response.headers().names()) {
                commentBuilder.append(header).append(": ").append(response.headers().get(header)).append("\n");
            }
            commentBuilder.append("\nBODY: ").append(response.body().string()).append("\n");
            return new BasicProbeResult(commentBuilder.toString(), response.isSuccessful());
        }
        catch (Exception e) {
            commentBuilder.append((CharSequence)ProbeUtils.getRequestHeadersAndCurl(request));
            logger.error(e.getMessage());
            commentBuilder.append("exception: ").append(e.getMessage()).append("\n");
            return new BasicProbeResult(commentBuilder.toString(), false);
        }
    }

    private static String filterAndFormatHeaders(Headers headers, BiFunction<String, String, String> formatter) {
        return String.join((CharSequence)"", headers.names().stream().map(header -> (String)formatter.apply((String)header, header.toLowerCase().startsWith("authorization") ? "*****" : headers.get(header)))::iterator);
    }

    public static class BasicProbeResult {
        private String result;
        private boolean isSuccess;

        BasicProbeResult(String result, boolean isSuccess) {
            this.result = result;
            this.isSuccess = isSuccess;
        }

        public String getResult() {
            return this.result;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }
    }
}

