/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.components.prAggregators.PRCommitsAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.components.prAggregators.PRDataAggregator;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.repository.PullRequestRepository;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketPRsCrawl;
import com.xebialabs.agatha.crawlers.bitbucket.transform.converters.PRConverter;
import com.xebialabs.agatha.crawlers.bitbucket.transform.models.pr.PullRequestUM;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.shared.transform.UMConverter;
import com.xebialabs.agatha.crawlers.shared.transform.UMWrappedEntity;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketPRCrawl
extends BitbucketBaseCrawl<BitbucketPRJobMessage, PullRequest> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketPRsCrawl.class);
    private final UMConverter<PullRequestUM, PullRequest> converter;
    private final KeyValueRepository<PullRequestUM> repository;

    public BitbucketPRCrawl(BitbucketCrawler crawler, BitbucketPRJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.converter = new PRConverter("PULL_REQUEST", "v1", "BitbucketCloudPlugin", "v1").setTeam(message.getTeamName()).setRepo(message.getRepoName());
        this.repository = new PullRequestRepository(crawler, dataMessage);
    }

    protected boolean isValid() {
        return ((BitbucketCrawler)this.crawler).decideToContinueBeforeCrawling(this.dataMessage, String.valueOf(((BitbucketPRJobMessage)this.message).getVersion()), BitbucketUtil.generateDataId(((BitbucketPRJobMessage)this.message).getTeamName(), ((BitbucketPRJobMessage)this.message).getRepoName(), String.valueOf(((BitbucketPRJobMessage)this.message).getId())), DataSourceTypeEnum.PULL_REQUEST);
    }

    @Override
    protected CrawledDataWrappedResponse<PullRequest> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketPRJobMessage for endpoint {}, pull request - {}, - team {}, repo - {} ", new Object[]{((BitbucketPRJobMessage)this.message).getBaseUrl(), ((BitbucketPRJobMessage)this.message).getId(), ((BitbucketPRJobMessage)this.message).getTeamName(), ((BitbucketPRJobMessage)this.message).getRepoName()});
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(PullRequest.class, ((BitbucketPRJobMessage)this.message).crawlUrl());
        this.handleResponse((PullRequest)response.getEntity());
        return response;
    }

    private void handleResponse(PullRequest pr) throws CrawlerWorkException {
        logger.debug("Saving PR {} in project - {}, repo - {}", new Object[]{pr.getId(), ((BitbucketPRJobMessage)this.message).getTeamName(), ((BitbucketPRJobMessage)this.message).getRepoName()});
        this.enrichPR(pr);
        UMWrappedEntity umWrappedEntity = this.converter.convert((Object)pr);
        boolean crawlCommits = this.repository.save(umWrappedEntity);
        if (crawlCommits) {
            Map<String, String> shas = this.commitShas(pr);
            logger.debug("Pushing {} PR commit depth jobs from pull request {}", (Object)shas.size(), (Object)pr.getId());
            this.sendCommitDepthJobMessages((BitbucketRepoJobMessage)this.message, shas);
        }
    }

    private Map<String, String> commitShas(PullRequest pullRequest) {
        Map<String, String> shas = pullRequest.getCommits().stream().map(commit -> new AbstractMap.SimpleEntry<String, String>(commit.getHash(), commit.linkFor("self"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (pullRequest.getMergeCommit() != null) {
            shas.put(pullRequest.getMergeCommit().getHash(), pullRequest.getMergeCommit().linkFor("self"));
        }
        return shas;
    }

    private List<PRDataAggregator> aggregators() {
        return Stream.of(new PRCommitsAggregator((BitbucketPRJobMessage)this.message, (BitbucketCrawler)this.crawler)).collect(Collectors.toList());
    }

    private void enrichPR(PullRequest pr) throws CrawlerWorkException {
        for (PRDataAggregator aggregator : this.aggregators()) {
            aggregator.populate(pr);
        }
    }
}

