/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucket.services;

import com.xebialabs.agatha.crawlers.bitbucket.BitbucketCrawler;
import com.xebialabs.agatha.crawlers.bitbucket.BitbucketUtil;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.messages.BitbucketPRsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucket.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucket.models.dtos.PRsResponse;
import com.xebialabs.agatha.crawlers.bitbucket.services.BitbucketBaseCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.agatha.crawlers.shared.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.shared.services.Paginated;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketPRsCrawl
extends BitbucketBaseCrawl<BitbucketPRsJobMessage, PRsResponse>
implements Paginated {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketPRsCrawl.class);

    public BitbucketPRsCrawl(BitbucketCrawler crawler, BitbucketPRsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketPRsJobMessage.class, this.message).setUrl(this.nextURL);
            return this.createDataMessage(BitbucketPRsJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<PRsResponse> processBitbucketMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketRepoPRJobMessage for team {} , repo {}", (Object)((BitbucketPRsJobMessage)this.message).getTeamName(), (Object)((BitbucketPRsJobMessage)this.message).getRepoName());
        CrawledDataWrappedResponse response = this.responseFetcher.fetchEntity(PRsResponse.class, ((BitbucketPRsJobMessage)this.message).crawlUrl());
        this.handleResponse((CrawledDataWrappedResponse<PRsResponse>)response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<PRsResponse> response) throws CrawlerWorkException {
        PRsResponse prsResponse = (PRsResponse)((Object)response.getEntity());
        logger.debug("Found {} PRs for team - {}, repo - {}", new Object[]{prsResponse.getValues().size(), ((BitbucketPRsJobMessage)this.message).getTeamName(), ((BitbucketPRsJobMessage)this.message).getRepoName()});
        for (PullRequest pr : prsResponse.getValues()) {
            this.sendPRJobMessage(pr);
        }
    }

    private void sendPRJobMessage(PullRequest pullRequest) throws CrawlerWorkException {
        try {
            BitbucketJobMessage dm = ((BitbucketCrawler)this.crawler).generateNewMessage(BitbucketPRJobMessage.class, this.message).setId(pullRequest.getId()).setVersion(BitbucketUtil.asDate(pullRequest.getUpdatedOn())).setUrl(pullRequest.linkFor("self"));
            ((BitbucketCrawler)this.crawler).sendCrawlerTaskMessage(this.createDataMessage(BitbucketPRJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

