/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.jsonstreaming;

import com.xebialabs.agatha.jsonstreaming.DataConsumer;
import com.xebialabs.agatha.jsonstreaming.ErrorHandler;
import com.xebialabs.agatha.jsonstreaming.FinishEventHandler;
import com.xebialabs.agatha.jsonstreaming.ParserIOException;
import com.xebialabs.agatha.jsonstreaming.RawConsumer;
import com.xebialabs.agatha.jsonstreaming.Utf8Reader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ParserCore<T extends ParserCore>
extends OutputStream {
    private int offset;
    private int nextOffset;
    private char[] buffer;
    private char[] rawBuffer;
    private int bufferLength;
    private boolean skipIndexesInPaths;
    private static final byte OBJECT = 1;
    private static final byte ARRAY = 2;
    private static final byte VALUE = 3;
    private static final byte OBJECTKEY = 4;
    private static final byte OBJECTVALUE = 5;
    private static final byte READING = 10;
    private static final byte READING_OBJECT_KEY = 11;
    private static final byte READING_STRING_VALUE = 12;
    private static final byte READING_NONSTRING_VALUE = 13;
    private static final byte CONTINUE_READING = 20;
    private static final byte CONTINUE_READING_OBJECT_KEY = 21;
    private static final byte CONTINUE_READING_STRING_VALUE = 22;
    private static final byte CONTINUE_READING_NONSTRING_VALUE = 23;
    private static final byte ABORTED = 24;
    private static final byte CLOSED = 25;
    private static final byte CALLBACK_ON_DEEP_OBJECT = 2;
    private static final byte CALLBACK_ON_DEEP_ARRAY = 4;
    private static final byte CALLBACK_ON_DEEP_VALUE = 6;
    private static final byte CALLBACK_ON_FINISH = 7;
    private static final byte CALLBACK_ON_DEEP_DATA = 9;
    private static final byte CALLBACK_ON_ERROR = 10;
    private byte[] stateStack = new byte[1];
    private int stateStackTop = -1;
    private Object[] callbackStack = new Object[1];
    private byte[] callbackTypeStack = new byte[1];
    private int[] callbackStackToStateStackMap = new int[1];
    private int callbackStackTop = -1;
    private final Utf8Reader src;
    private StringBuilder path = new StringBuilder();
    private int[] pathPositions = new int[256];
    private int[] pathArrayIndexes = new int[256];
    private int pathPositionTop;
    private List<RawConsumer> rawConsumers = new ArrayList<RawConsumer>();
    private int endOfStringValuePos;
    private boolean stringValueIsComplete;
    private int escapeAccumulator;
    private int escapeInProgress;
    private int extraStringCharsToAccept;
    private int endOfNonStringValuePos;
    private boolean nonStringValueIsComplete;

    public ParserCore() {
        this.src = new Utf8Reader(this);
        this.addState((byte)3);
    }

    public T onDeepObject(Consumer<CharSequence> fn) {
        this.addCallback(fn, (byte)2);
        return (T)this;
    }

    public T onDeepArray(Consumer<CharSequence> fn) {
        this.addCallback(fn, (byte)4);
        return (T)this;
    }

    public T onDeepValue(BiConsumer<CharSequence, Type> fn) {
        this.addCallback(fn, (byte)6);
        return (T)this;
    }

    public T onDeepData(DataConsumer fn) {
        this.addCallback(fn, (byte)9);
        return (T)this;
    }

    public T onFinish(FinishEventHandler fn) {
        this.addCallback(fn, (byte)7);
        return (T)this;
    }

    public T onError(ErrorHandler fn) {
        this.addCallback(fn, (byte)10);
        return (T)this;
    }

    public T onRaw(RawConsumer fn) {
        for (int i = 0; i < this.rawConsumers.size(); ++i) {
            if (this.rawConsumers.get(i) != null) continue;
            this.rawConsumers.set(i, this.makeRawConsumer(fn, i));
            return (T)this;
        }
        this.rawConsumers.add(this.makeRawConsumer(fn, this.rawConsumers.size()));
        return (T)this;
    }

    private RawConsumer makeRawConsumer(RawConsumer fn, int consumerIndex) {
        int[] startOffset = new int[]{this.offset};
        this.onFinish(() -> {
            int start = startOffset[0] == -1 ? 0 : startOffset[0];
            int finish = this.nextOffset;
            fn.accept(this.rawBuffer, start, finish - start);
            this.rawConsumers.set(consumerIndex, null);
        });
        return (buf, off, length) -> {
            int start = startOffset[0] == -1 ? off : startOffset[0];
            int finish = off + length;
            fn.accept(buf, start, finish - start);
            startOffset[0] = -1;
        };
    }

    private void addCallback(Object callback, byte type) {
        if (this.callbackStackTop == this.callbackStack.length - 1) {
            int newLength = this.callbackStack.length * 2;
            Object[] newCallbackStack = new Object[newLength];
            System.arraycopy(this.callbackStack, 0, newCallbackStack, 0, this.callbackStack.length);
            this.callbackStack = newCallbackStack;
            int[] newCallbackStackToStateStackMap = new int[newLength];
            System.arraycopy(this.callbackStackToStateStackMap, 0, newCallbackStackToStateStackMap, 0, this.callbackStackToStateStackMap.length);
            this.callbackStackToStateStackMap = newCallbackStackToStateStackMap;
            byte[] newCallbackTypeStack = new byte[newLength];
            System.arraycopy(this.callbackTypeStack, 0, newCallbackTypeStack, 0, this.callbackTypeStack.length);
            this.callbackTypeStack = newCallbackTypeStack;
        }
        this.callbackStack[++this.callbackStackTop] = callback;
        this.callbackStackToStateStackMap[this.callbackStackTop] = this.stateStackTop;
        this.callbackTypeStack[this.callbackStackTop] = type;
    }

    public int getCurrentLevel() {
        return this.pathPositionTop;
    }

    private void clearCallbacks() throws IOException {
        while (this.callbackStackTop >= 0 && this.callbackStackToStateStackMap[this.callbackStackTop] > this.stateStackTop) {
            if (this.callbackTypeStack[this.callbackStackTop] == 7) {
                ((FinishEventHandler)this.callbackStack[this.callbackStackTop]).handle();
            }
            this.callbackStack[this.callbackStackTop] = null;
            --this.callbackStackTop;
        }
    }

    private void clearRootCallbacks() throws IOException {
        while (this.callbackStackTop >= 0) {
            if (this.callbackTypeStack[this.callbackStackTop] == 7) {
                ((FinishEventHandler)this.callbackStack[this.callbackStackTop]).handle();
            }
            this.callbackStack[this.callbackStackTop] = null;
            --this.callbackStackTop;
        }
    }

    private void callCallbacks(Type type) throws IOException {
        switch (type) {
            case OBJECT: {
                for (int i = 0; i <= this.callbackStackTop; ++i) {
                    if (this.callbackTypeStack[i] != 2) continue;
                    ((Consumer)this.callbackStack[i]).accept(this.path);
                }
                break;
            }
            case ARRAY: {
                for (int i = 0; i <= this.callbackStackTop; ++i) {
                    if (this.callbackTypeStack[i] != 4) continue;
                    ((Consumer)this.callbackStack[i]).accept(this.path);
                }
                break;
            }
            case STRING: 
            case NON_STRING: {
                for (int i = 0; i <= this.callbackStackTop; ++i) {
                    if (this.callbackTypeStack[i] != 6) continue;
                    ((BiConsumer)this.callbackStack[i]).accept(this.path, type);
                }
                break;
            }
            case STRING_DATA: 
            case CONTINUE_STRING_DATA: {
                for (int i = 0; i <= this.callbackStackTop; ++i) {
                    if (this.callbackTypeStack[i] != 9) continue;
                    ((DataConsumer)this.callbackStack[i]).accept(this.buffer, this.offset, this.endOfStringValuePos - this.offset, type == Type.STRING_DATA, this.stringValueIsComplete);
                }
                break;
            }
            case NON_STRING_DATA: 
            case CONTINUE_NON_STRING_DATA: {
                for (int i = 0; i <= this.callbackStackTop; ++i) {
                    if (this.callbackTypeStack[i] != 9) continue;
                    ((DataConsumer)this.callbackStack[i]).accept(this.buffer, this.offset, this.endOfNonStringValuePos - this.offset, type == Type.NON_STRING_DATA, this.nonStringValueIsComplete);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void callErrorCallbacks(Supplier<Throwable> supplier) throws IOException {
        for (int i = 0; i <= this.callbackStackTop; ++i) {
            if (this.callbackTypeStack[i] != 10) continue;
            ((ErrorHandler)this.callbackStack[i]).handle(supplier.get());
        }
    }

    public Path getRelativePath(int i) {
        int pos = i == 0 ? 0 : this.pathPositions[i - 1];
        return pos > 0 ? new Path(pos, this.path.length(), this.pathPositionTop - i - 1) : new Path(0, this.path.length(), this.pathPositionTop - i - 1);
    }

    private void addState(byte state) {
        if (this.stateStackTop == this.stateStack.length - 1) {
            int newLength = this.stateStack.length << 1;
            byte[] newStackState = new byte[newLength];
            System.arraycopy(this.stateStack, 0, newStackState, 0, this.stateStack.length);
            this.stateStack = newStackState;
        }
        this.stateStack[++this.stateStackTop] = state;
    }

    private void popState() throws IOException {
        --this.stateStackTop;
        if (this.stateStackTop < 0) {
            throw new IOException("bad json");
        }
        this.clearCallbacks();
    }

    private void replaceState(byte state) {
        this.stateStack[this.stateStackTop] = state;
    }

    private void addPath(String pc, int arrayIndex) {
        this.path.append(pc);
        this.pathPositions[this.pathPositionTop] = this.path.length();
        this.pathArrayIndexes[this.pathPositionTop] = arrayIndex;
        ++this.pathPositionTop;
    }

    private void popPath() {
        --this.pathPositionTop;
        this.path.setLength(this.pathPositionTop == 0 ? 0 : this.pathPositions[this.pathPositionTop - 1]);
    }

    private void incArrayPath() {
        int n = this.pathPositionTop - 1;
        this.pathArrayIndexes[n] = this.pathArrayIndexes[n] + 1;
        if (!this.skipIndexesInPaths) {
            this.path.setLength((this.pathPositionTop == 1 ? 0 : this.pathPositions[this.pathPositionTop - 2]) + 1);
            this.path.append(this.pathArrayIndexes[this.pathPositionTop - 1]);
            this.path.append(']');
            if (this.pathPositionTop > 0) {
                this.pathPositions[this.pathPositionTop - 1] = this.path.length();
            }
        }
    }

    public int getArrayElementIndexAtLevel(int i) {
        return this.pathArrayIndexes[i];
    }

    public void error() throws ParserIOException {
        throw new ParserIOException("invalid json: [" + this.buffer[this.offset] + "] is not expected in [" + this.stateStack[this.stateStackTop] + "] state");
    }

    void onDataAvailable(char[] decodedCharBuffer, int length) throws IOException {
        try {
            this.buffer = decodedCharBuffer;
            this.rawBuffer = new char[length];
            System.arraycopy(decodedCharBuffer, 0, this.rawBuffer, 0, length);
            this.bufferLength = length;
            this.offset = 0;
            block24: while (this.offset < length) {
                byte topState = this.stateStack[this.stateStackTop];
                if (topState > 10) {
                    if (topState > 20) {
                        switch (topState) {
                            case 22: {
                                this.estimateStringValue();
                                this.callCallbacks(Type.CONTINUE_STRING_DATA);
                                this.nextOffset = this.endOfStringValuePos + this.extraStringCharsToAccept;
                                if (this.stringValueIsComplete) {
                                    this.popState();
                                }
                                this.offset = this.nextOffset;
                                continue block24;
                            }
                            case 23: {
                                this.estimateNonStringValue();
                                this.callCallbacks(Type.CONTINUE_NON_STRING_DATA);
                                this.nextOffset = this.endOfNonStringValuePos;
                                if (this.nonStringValueIsComplete) {
                                    this.popState();
                                }
                                this.offset = this.nextOffset;
                                continue block24;
                            }
                            case 21: {
                                this.estimateStringValue();
                                this.nextOffset = this.endOfStringValuePos + this.extraStringCharsToAccept;
                                if (this.stringValueIsComplete) {
                                    this.path.append(decodedCharBuffer, this.offset, this.endOfStringValuePos - this.offset);
                                    this.pathPositions[this.pathPositionTop - 1] = this.path.length();
                                    this.popState();
                                    this.addState((byte)4);
                                } else {
                                    this.path.append(decodedCharBuffer, this.offset, this.endOfStringValuePos - this.offset);
                                    this.pathPositions[this.pathPositionTop - 1] = this.path.length();
                                }
                                this.offset = this.nextOffset;
                                continue block24;
                            }
                            case 24: {
                                throw new IllegalStateException("Parser is in aborted state, no further data writes are possible");
                            }
                            case 25: {
                                throw new IllegalStateException("Parser is in closed state, no further data writes are possible");
                            }
                        }
                        throw new IllegalStateException();
                    }
                    switch (topState) {
                        case 12: {
                            this.estimateStringValue();
                            this.callCallbacks(Type.STRING_DATA);
                            this.nextOffset = this.endOfStringValuePos + this.extraStringCharsToAccept;
                            if (this.stringValueIsComplete) {
                                this.popState();
                            } else {
                                this.replaceState((byte)22);
                            }
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                        case 11: {
                            this.estimateStringValue();
                            this.path.setLength((this.pathPositionTop == 1 ? 0 : this.pathPositions[this.pathPositionTop - 2]) + 1);
                            this.nextOffset = this.endOfStringValuePos + this.extraStringCharsToAccept;
                            if (this.stringValueIsComplete) {
                                this.path.append(decodedCharBuffer, this.offset, this.endOfStringValuePos - this.offset);
                                this.pathPositions[this.pathPositionTop - 1] = this.path.length();
                                this.popState();
                                this.addState((byte)4);
                            } else {
                                this.path.append(decodedCharBuffer, this.offset, this.endOfStringValuePos - this.offset);
                                this.pathPositions[this.pathPositionTop - 1] = this.path.length();
                                this.replaceState((byte)21);
                            }
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                        case 13: {
                            this.estimateNonStringValue();
                            this.callCallbacks(Type.NON_STRING_DATA);
                            this.nextOffset = this.endOfNonStringValuePos;
                            if (this.nonStringValueIsComplete) {
                                this.popState();
                            } else {
                                this.replaceState((byte)23);
                            }
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                    }
                    throw new IllegalStateException();
                }
                switch (decodedCharBuffer[this.offset]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++this.offset;
                        continue block24;
                    }
                    case '{': {
                        if (topState == 3 || topState == 5 || topState == 2) {
                            this.addState((byte)1);
                            this.callCallbacks(Type.OBJECT);
                            this.addPath(".", 0);
                            ++this.offset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                    case '[': {
                        if (topState == 3 || topState == 5 || topState == 2) {
                            this.addState((byte)2);
                            this.callCallbacks(Type.ARRAY);
                            this.addPath(this.skipIndexesInPaths ? "[]" : "[0]", 0);
                            ++this.offset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                    case '}': {
                        if (topState == 1) {
                            this.popPath();
                            this.nextOffset = this.offset + 1;
                            this.popState();
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                        if (topState == 5) {
                            this.popPath();
                            this.nextOffset = this.offset;
                            this.popState();
                            this.nextOffset = this.offset + 1;
                            this.popState();
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                    case ']': {
                        if (topState == 2) {
                            this.popPath();
                            this.nextOffset = this.offset + 1;
                            this.popState();
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                    case '\"': {
                        if (topState == 1) {
                            this.addState((byte)11);
                            this.escapeInProgress = 0;
                            ++this.offset;
                            continue block24;
                        }
                        if (topState == 2) {
                            this.addState((byte)12);
                            this.callCallbacks(Type.STRING);
                            ++this.offset;
                            continue block24;
                        }
                        if (topState == 5) {
                            this.addState((byte)12);
                            this.callCallbacks(Type.STRING);
                            ++this.offset;
                            continue block24;
                        }
                        if (topState == 3) {
                            this.addState((byte)12);
                            this.callCallbacks(Type.STRING);
                            ++this.offset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                    case ':': {
                        if (topState == 4) {
                            this.nextOffset = this.offset + 1;
                            this.popState();
                            this.addState((byte)5);
                            this.offset = this.nextOffset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                    case ',': {
                        if (topState == 5 || topState == 3) {
                            this.nextOffset = this.offset;
                            this.popState();
                        }
                        if ((topState = this.stateStack[this.stateStackTop]) == 1) {
                            ++this.offset;
                            continue block24;
                        }
                        if (topState == 2) {
                            this.incArrayPath();
                            ++this.offset;
                            continue block24;
                        }
                        this.error();
                        continue block24;
                    }
                }
                if (topState == 3 || topState == 5 || topState == 2) {
                    this.addState((byte)13);
                    this.callCallbacks(Type.NON_STRING);
                    continue;
                }
                this.error();
            }
            for (int i = 0; i < this.rawConsumers.size(); ++i) {
                RawConsumer rawConsumer = this.rawConsumers.get(i);
                if (rawConsumer == null) continue;
                rawConsumer.accept(this.rawBuffer, 0, length);
            }
        }
        catch (Exception e) {
            this.callErrorCallbacks(() -> e);
            this.stateStack[0] = 24;
            this.stateStackTop = 0;
            throw e;
        }
    }

    private void estimateNonStringValue() {
        this.endOfNonStringValuePos = this.offset;
        while (this.endOfNonStringValuePos < this.bufferLength) {
            char c = this.buffer[this.endOfNonStringValuePos];
            if (c == ',' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == '\r') {
                this.nonStringValueIsComplete = true;
                return;
            }
            ++this.endOfNonStringValuePos;
        }
        this.nonStringValueIsComplete = false;
    }

    private void estimateStringValue() {
        this.endOfStringValuePos = this.offset;
        while (this.endOfStringValuePos < this.bufferLength) {
            block18: {
                block16: {
                    block17: {
                        if (this.escapeInProgress <= 0) break block16;
                        if (this.escapeInProgress != 1) break block17;
                        switch (this.buffer[this.endOfStringValuePos]) {
                            case 'n': {
                                this.buffer[this.endOfStringValuePos] = 10;
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case 'r': {
                                this.buffer[this.endOfStringValuePos] = 13;
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case 't': {
                                this.buffer[this.endOfStringValuePos] = 9;
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case 'b': {
                                this.buffer[this.endOfStringValuePos] = 8;
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case 'f': {
                                this.buffer[this.endOfStringValuePos] = 12;
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case '\\': {
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case '/': {
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case '\"': {
                                this.escapeInProgress = 0;
                                break block18;
                            }
                            case 'u': {
                                this.escapeInProgress = 2;
                                this.escapeAccumulator = 0;
                                ++this.offset;
                                break block18;
                            }
                            default: {
                                throw new RuntimeException("TBD: [" + this.buffer[this.endOfStringValuePos] + "]");
                            }
                        }
                    }
                    this.escapeAccumulator = (this.escapeAccumulator << 4) + Integer.parseInt(new String(this.buffer, this.endOfStringValuePos, 1), 16);
                    if (this.escapeInProgress == 5) {
                        this.buffer[this.offset] = (char)this.escapeAccumulator;
                        this.escapeInProgress = 0;
                    } else {
                        ++this.escapeInProgress;
                        ++this.offset;
                    }
                    break block18;
                }
                if (this.buffer[this.endOfStringValuePos] == '\"') {
                    this.stringValueIsComplete = true;
                    this.extraStringCharsToAccept = 1;
                    return;
                }
                if (this.buffer[this.endOfStringValuePos] == '\\') {
                    this.stringValueIsComplete = false;
                    this.escapeInProgress = 1;
                    this.extraStringCharsToAccept = 1;
                    return;
                }
            }
            ++this.endOfStringValuePos;
        }
        this.extraStringCharsToAccept = 0;
        this.stringValueIsComplete = false;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.src.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.src.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.src.write(b, off, len);
    }

    public T setSkipIndexesInPaths(boolean skipIndexesInPaths) {
        this.skipIndexesInPaths = skipIndexesInPaths;
        return (T)this;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        super.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void finish() throws IOException {
        try {
            if (this.src.hasLeftCharacters()) {
                throw new IOException("Incomplete UTF-8 char on the tail of stream");
            }
            if (this.stateStackTop > 1) {
                throw new IOException("invalid JSON, stream was finished too early");
            }
            if (this.stateStackTop != 1) return;
            switch (this.stateStack[this.stateStackTop]) {
                case 23: {
                    this.endOfNonStringValuePos = this.offset = 0;
                    this.nonStringValueIsComplete = true;
                    this.callCallbacks(Type.CONTINUE_NON_STRING_DATA);
                    return;
                }
                default: {
                    throw new IOException("invalid JSON");
                }
            }
        }
        finally {
            this.clearRootCallbacks();
            this.callErrorCallbacks(() -> new RuntimeException("finish called too early, there are "));
            this.stateStack[0] = 25;
            this.stateStackTop = 0;
        }
    }

    public String dump() {
        String inTheMiddle = new String(this.buffer, this.offset, 1) + "<<<<<===== " + (this.offset < this.bufferLength - 1 ? new String(this.buffer, this.offset + 1, this.bufferLength - this.offset - 1) : "");
        return new String(this.buffer, 0, this.offset) + " =====>>>>>" + (this.offset < this.bufferLength ? inTheMiddle : "");
    }

    public static enum Type {
        OBJECT,
        ARRAY,
        STRING,
        NON_STRING,
        FINISH,
        STRING_DATA,
        NON_STRING_DATA,
        CONTINUE_STRING_DATA,
        CONTINUE_NON_STRING_DATA,
        ERROR;

    }

    public class Path
    implements CharSequence {
        private final int start;
        private final int end;
        private final int level;

        public Path(int offset, int end, int level) {
            this.start = offset;
            this.end = end;
            this.level = level;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return ParserCore.this.path.charAt(this.start + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (end > this.end - this.start) {
                throw new IndexOutOfBoundsException();
            }
            return new Path(this.start + start, this.start + end, -1);
        }

        @Override
        public String toString() {
            return ParserCore.this.path.substring(this.start, this.end);
        }

        public int getLevel() {
            return this.level;
        }
    }
}

