/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import okhttp3.HttpUrl;

public final class BitbucketServerURLHelper {
    private static final String API_VERSION = "1.0";

    private BitbucketServerURLHelper() {
    }

    private static Map<String, String> protocolAndHost(String endPoint) throws CrawlerWorkException {
        try {
            URL baseUrl = new URL(endPoint);
            return ImmutableMap.of((Object)"protocol", (Object)baseUrl.getProtocol(), (Object)"host", (Object)baseUrl.getHost(), (Object)"port", (Object)(baseUrl.getPort() + ""));
        }
        catch (MalformedURLException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    private static HttpUrl.Builder baseUrlBuilder(String endPoint) throws CrawlerWorkException {
        Map<String, String> protocolAndHost = BitbucketServerURLHelper.protocolAndHost(endPoint);
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(protocolAndHost.get("protocol")).host(protocolAndHost.get("host")).addPathSegment("rest").addPathSegment("api").addPathSegment(API_VERSION);
        if ("-1".equals(protocolAndHost.get("port"))) {
            return builder;
        }
        return builder.port(Integer.parseInt(protocolAndHost.get("port")));
    }

    private static HttpUrl.Builder basePathBuilder(String endPoint, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = BitbucketServerURLHelper.baseUrlBuilder(endPoint);
        for (String path : pathSegments) {
            builder.addPathSegment(path);
        }
        return builder;
    }

    private static URL baseEntitiesURL(String endPoint, int limit, int offset, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = BitbucketServerURLHelper.basePathBuilder(endPoint, pathSegments);
        return builder.addQueryParameter("limit", limit + "").addQueryParameter("start", offset + "").build().url();
    }

    private static URL baseEntityURL(String endPoint, String ... pathSegments) throws CrawlerWorkException {
        HttpUrl.Builder builder = BitbucketServerURLHelper.basePathBuilder(endPoint, pathSegments);
        return builder.build().url();
    }

    public static URL reposURL(String endPoint, int limit, int offset) throws CrawlerWorkException {
        URL baseUrl = BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "repos");
        String suffix = "&permission=REPO_READ";
        return HttpUrl.parse((String)(baseUrl.toString() + "&permission=REPO_READ")).url();
    }

    public static URL commitsURL(String endPoint, int limit, int offset, String projectKey, String repoSlug) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "projects", projectKey, "repos", repoSlug, "commits");
    }

    public static URL pullRequestsURL(String endPoint, int limit, int offset, String projectKey, String repoSlug, Map<String, String> queryParams) throws CrawlerWorkException {
        URL url = BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "projects", projectKey, "repos", repoSlug, "pull-requests");
        HttpUrl.Builder builder = HttpUrl.parse((String)url.toString()).newBuilder();
        if (queryParams != null && !queryParams.isEmpty()) {
            queryParams.entrySet().stream().forEach(param -> builder.addQueryParameter((String)param.getKey(), (String)param.getValue()));
        }
        return builder.build().url();
    }

    public static URL pullRequestURL(String endPoint, String projectKey, String repoSlug, String id) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntityURL(endPoint, "projects", projectKey, "repos", repoSlug, "pull-requests", id);
    }

    public static URL pullRequestCommitsURL(String endPoint, int limit, int offset, String projectKey, String repoSlug, String id) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "projects", projectKey, "repos", repoSlug, "pull-requests", id, "commits");
    }

    public static URL pullRequestActivitiesURL(String endPoint, int limit, int offset, String projectKey, String repoSlug, String id) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "projects", projectKey, "repos", repoSlug, "pull-requests", id, "activities");
    }

    public static URL diffsURL(String endPoint, String projectKey, String repoSlug, String requestType, String id) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntityURL(endPoint, "projects", projectKey, "repos", repoSlug, requestType, id, "diff");
    }

    public static URL tagsURL(String endPoint, int limit, int offset, String projectKey, String repoSlug) throws CrawlerWorkException {
        URL baseUrl = BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "projects", projectKey, "repos", repoSlug, "tags");
        String suffixQuery = "&orderBy=MODIFICATION";
        return HttpUrl.parse((String)(baseUrl + suffixQuery)).url();
    }

    public static URL commitURL(String endPoint, String projectKey, String repoSlug, String id) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntityURL(endPoint, "projects", projectKey, "repos", repoSlug, "commits", id);
    }

    public static URL branchesURL(String endPoint, int limit, int offset, String projectKey, String repoSlug) throws CrawlerWorkException {
        return BitbucketServerURLHelper.baseEntitiesURL(endPoint, limit, offset, "projects", projectKey, "repos", repoSlug, "branches");
    }
}

