/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestsJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.PRsResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BasePaginatedCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerPullRequestsJobCrawl
extends BasePaginatedCrawl<BitbucketServerPullRequestsJobMessage, PRsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerPullRequestsJobCrawl.class);

    public BitbucketServerPullRequestsJobCrawl(BitbucketServerCrawler crawler, BitbucketServerPullRequestsJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    @Override
    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketServerJobMessage dm = this.crawler.generateNewMessage(BitbucketServerPullRequestsJobMessage.class, this.message).setLimit(((BitbucketServerPullRequestsJobMessage)this.message).getLimit()).setOffset(((BitbucketServerPullRequestsJobMessage)this.message).nextOffSet());
            return this.createDataMessage(this.message, BitbucketServerPullRequestsJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<PRsResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerPRsJobMessage for endpoint {} - project {}, repo - {} ", new Object[]{((BitbucketServerPullRequestsJobMessage)this.message).getBaseUrl(), ((BitbucketServerPullRequestsJobMessage)this.message).getProjectKey(), ((BitbucketServerPullRequestsJobMessage)this.message).getRepoSlug()});
        CrawledDataWrappedResponse<PRsResponse> response = this.responseFetcher.fetchEntity(PRsResponse.class, ((BitbucketServerPullRequestsJobMessage)this.message).url());
        this.handleResponse(response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<PRsResponse> response) throws CrawlerWorkException {
        PRsResponse prsResponse = response.getEntity();
        logger.debug("Found {} PRs in project - {}, repo - {}", new Object[]{prsResponse.getValues().size(), ((BitbucketServerPullRequestsJobMessage)this.message).getProjectKey(), ((BitbucketServerPullRequestsJobMessage)this.message).getRepoSlug()});
        for (PullRequest pr : prsResponse.getValues()) {
            this.sendPRJobMessage(pr);
        }
    }

    private void sendPRJobMessage(PullRequest pullRequest) throws CrawlerWorkException {
        try {
            BitbucketServerPullRequestJobMessage dm = this.crawler.generateNewMessage(BitbucketServerPullRequestJobMessage.class, this.message).setId(pullRequest.getId()).setVersion(pullRequest.getUpdatedDate());
            this.crawler.sendCrawlerTaskMessage(this.createDataMessage(this.message, BitbucketServerPullRequestJobMessage.class.getSimpleName(), dm));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }
}

