/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerBranchJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Branch;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.dtos.BranchResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BasePaginatedCrawl;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerBranchCrawl
extends BasePaginatedCrawl<BitbucketServerBranchJobMessage, BranchResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerBranchCrawl.class);

    public BitbucketServerBranchCrawl(BitbucketServerCrawler crawler, BitbucketServerBranchJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
    }

    @Override
    protected BaseCrawlerMessage newMessage() throws CrawlerWorkException {
        try {
            BitbucketServerJobMessage dm = this.crawler.generateNewMessage(BitbucketServerBranchJobMessage.class, this.message).setLimit(((BitbucketServerBranchJobMessage)this.message).getLimit()).setOffset(((BitbucketServerBranchJobMessage)this.message).nextOffSet());
            return this.createDataMessage(this.message, BitbucketServerBranchJobMessage.class.getSimpleName(), dm);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CrawlerWorkException((Throwable)e);
        }
    }

    @Override
    protected CrawledDataWrappedResponse<BranchResponse> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerBranchJobMessage for endpoint {} - project {}, repo - {} ", new Object[]{((BitbucketServerBranchJobMessage)this.message).getBaseUrl(), ((BitbucketServerBranchJobMessage)this.message).getProjectKey(), ((BitbucketServerBranchJobMessage)this.message).getRepoSlug()});
        CrawledDataWrappedResponse<BranchResponse> response = this.responseFetcher.fetchEntity(BranchResponse.class, ((BitbucketServerBranchJobMessage)this.message).url());
        this.handleResponse(response);
        return response;
    }

    private void handleResponse(CrawledDataWrappedResponse<BranchResponse> response) throws CrawlerWorkException {
        BranchResponse branchResponse = response.getEntity();
        logger.debug("Found {} branches in project - {}, repo - {}", new Object[]{branchResponse.getValues().size(), ((BitbucketServerBranchJobMessage)this.message).getProjectKey(), ((BitbucketServerBranchJobMessage)this.message).getRepoSlug()});
        this.sendCommitDepthJobMessages((BitbucketServerRepoJobMessage)this.message, branchResponse.getValues().stream().map(Branch::getLatestCommit).collect(Collectors.toSet()));
    }
}

