/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.bitbucketserver.services;

import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerCrawler;
import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerURLHelper;
import com.xebialabs.agatha.crawlers.bitbucketserver.BitbucketServerUtil;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.CrawledDataWrappedResponse;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.DiffCalculator;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators.PRDataAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators.PullRequestActivitiesAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.components.prAggregators.PullRequestCommitsAggregator;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerPullRequestJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.messages.BitbucketServerRepoJobMessage;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Activity;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.Commit;
import com.xebialabs.agatha.crawlers.bitbucketserver.models.PullRequest;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.KeyValueRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.repository.PullRequestRepository;
import com.xebialabs.agatha.crawlers.bitbucketserver.services.BaseEntityCrawl;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.PRConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.converters.UMConverter;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.UMWrappedEntity;
import com.xebialabs.agatha.crawlers.bitbucketserver.transform.models.pr.PullRequestUM;
import com.xebialabs.agatha.crawlers.exceptions.CrawlerWorkException;
import com.xebialabs.impact.api.BaseCrawlerMessage;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketServerPullRequestJobCrawl
extends BaseEntityCrawl<BitbucketServerPullRequestJobMessage, PullRequest> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketServerPullRequestJobCrawl.class);
    private final UMConverter<PullRequestUM, PullRequest> converter;
    private final KeyValueRepository<PullRequestUM> repository;
    private final DiffCalculator diffCalculator;

    public BitbucketServerPullRequestJobCrawl(BitbucketServerCrawler crawler, BitbucketServerPullRequestJobMessage message, BaseCrawlerMessage dataMessage) {
        super(crawler, message, dataMessage);
        this.converter = new PRConverter("BitbucketServerPlugin", "v1", "PULL_REQUEST", "v1").setProject(message.getProjectKey()).setRepo(message.getRepoSlug());
        this.repository = new PullRequestRepository(crawler, dataMessage);
        this.diffCalculator = new DiffCalculator(crawler);
    }

    @Override
    protected CrawledDataWrappedResponse<PullRequest> processMessage() throws CrawlerWorkException {
        logger.debug("Process BitbucketServerPullRequestJobMessage for endpoint {}, pull request - {}, - project {}, repo - {} ", new Object[]{((BitbucketServerPullRequestJobMessage)this.message).getBaseUrl(), ((BitbucketServerPullRequestJobMessage)this.message).getId(), ((BitbucketServerPullRequestJobMessage)this.message).getProjectKey(), ((BitbucketServerPullRequestJobMessage)this.message).getRepoSlug()});
        CrawledDataWrappedResponse<PullRequest> response = this.responseFetcher.fetchEntity(PullRequest.class, ((BitbucketServerPullRequestJobMessage)this.message).url());
        this.handleResponse(response.getEntity());
        return response;
    }

    @Override
    protected boolean valid() {
        return this.crawler.decideToContinueBeforeCrawling(this.dataMessage, Long.toString(((BitbucketServerPullRequestJobMessage)this.message).getVersion()), BitbucketServerUtil.generateDataId(((BitbucketServerPullRequestJobMessage)this.message).getProjectKey(), ((BitbucketServerPullRequestJobMessage)this.message).getRepoSlug(), Long.toString(((BitbucketServerPullRequestJobMessage)this.message).getId())), DataSourceTypeEnum.PULL_REQUEST);
    }

    private void handleResponse(PullRequest pr) throws CrawlerWorkException {
        logger.debug("Saving PR {} in project - {}, repo - {}", new Object[]{pr.getId(), ((BitbucketServerPullRequestJobMessage)this.message).getProjectKey(), ((BitbucketServerPullRequestJobMessage)this.message).getRepoSlug()});
        this.enrichPR(pr);
        UMWrappedEntity<PullRequestUM> umWrappedEntity = this.converter.convert(pr);
        boolean crawlCommits = this.repository.save(umWrappedEntity);
        if (crawlCommits) {
            Set<String> shas = this.commitShas(pr);
            logger.debug("Pushing {} PR commit depth jobs from pull request {}", (Object)shas.size(), (Object)pr.getId());
            this.sendCommitDepthJobMessages((BitbucketServerRepoJobMessage)this.message, shas);
        }
    }

    private URL diffUrl() throws CrawlerWorkException {
        return BitbucketServerURLHelper.diffsURL(((BitbucketServerPullRequestJobMessage)this.message).getBaseUrl(), ((BitbucketServerPullRequestJobMessage)this.message).getProjectKey(), ((BitbucketServerPullRequestJobMessage)this.message).getRepoSlug(), "pull-requests", Long.toString(((BitbucketServerPullRequestJobMessage)this.message).getId()));
    }

    private List<PRDataAggregator> aggregators() {
        return Stream.of(new PullRequestCommitsAggregator((BitbucketServerPullRequestJobMessage)this.message, this.crawler), new PullRequestActivitiesAggregator((BitbucketServerPullRequestJobMessage)this.message, this.crawler)).collect(Collectors.toList());
    }

    private void enrichPR(PullRequest pr) throws CrawlerWorkException {
        for (PRDataAggregator aggregator : this.aggregators()) {
            aggregator.populate(pr);
        }
        pr.setChangeLog(this.diffCalculator.changeLogFromDiff(this.diffUrl()));
    }

    private Set<String> commitShas(PullRequest pullRequest) {
        Set<String> shas = pullRequest.getCommits().stream().map(Commit::getId).collect(Collectors.toSet());
        if (pullRequest.getActivities() != null) {
            pullRequest.getActivities().stream().filter(activity -> activity.getAction().equalsIgnoreCase("merged")).findFirst().map(Activity::getCommit).map(Commit::getId).ifPresent(id -> shas.add((String)id));
        }
        return shas;
    }
}

