/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.agatha.crawlers.api.IngestionApiAsync;
import com.xebialabs.agatha.logging.AgathaLogger;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownRequestVM;
import com.xebialabs.impact.api.CheckWhichUMArtefactsAreKnownResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMDataResponseVM;
import com.xebialabs.impact.api.PushCrawlerUMMessagesRequestVM;
import com.xebialabs.impact.api.PushProbeUMStatusRequestVM;
import com.xebialabs.impact.api.SetContextKeyRequest;
import com.xebialabs.impact.wave.WaveSystem;
import com.xebialabs.impact.wave.scripting.Launch;
import com.xebialabs.impact.wave.scripting.Probe;
import com.xebialabs.impact.wave.scripting.engine.MapInterface;
import com.xebialabs.impact.wave.scripting.engine.ReduceInterface;
import com.xebialabs.impact.wave.scripting.http.AckOrNackInterface;
import com.xebialabs.impact.wave.scripting.http.ApiInterfaceWithOrWithoutResponse;
import com.xebialabs.impact.wave.scripting.http.ApiInterfaceWithResponse;
import com.xebialabs.impact.wave.scripting.http.ApiInterfaceWithoutResponse;
import com.xebialabs.impact.wave.scripting.http.PushDataRequestVM;
import com.xebialabs.impact.wave.scripting.http.RequestComputingGraph;
import com.xebialabs.impact.wave.scripting.http.RequestInterface;
import com.xebialabs.impact.wave.scripting.http.WaveContext;
import com.xebialabs.impact.wave.scripting.http.signals.NoMoreData;
import com.xebialabs.impact.wave.scripting.http.signals.NoMoreMessages;
import io.vavr.CheckedFunction1;

public class PluginInterface {
    private static RequestComputingGraph stagingComputingGraph;
    private static RequestComputingGraph currentComputingGraph;
    private static String pluginId;
    private static boolean trace;

    public static <S> MapInterface<S, WaveContext> map(Class<S> c) {
        return stagingComputingGraph.map(c);
    }

    public static <S> ReduceInterface<S, WaveContext> reduce(Class<S> c, Class<?> ... otherClasses) {
        return stagingComputingGraph.reduce(c, otherClasses);
    }

    public static <S> void capture(Class<S> c, CheckedFunction1<S, Object> f) {
        stagingComputingGraph.capture(c, f);
    }

    public static MapInterface<Probe, WaveContext> probe() {
        return stagingComputingGraph.map(Probe.class);
    }

    public static MapInterface<Launch, WaveContext> launch() {
        return stagingComputingGraph.map(Launch.class);
    }

    public static <S> RequestInterface<S> request(Class<S> c) {
        return stagingComputingGraph.request(c);
    }

    public static <S> AckOrNackInterface<S> ackOrNack(Class<S> c, Class<S> ... other) {
        return stagingComputingGraph.ackOrNack(c, other);
    }

    public static <S> ApiInterfaceWithoutResponse<S, PushProbeUMStatusRequestVM, Void, Void> sendProbeResults(Class<S> c) {
        return stagingComputingGraph.sendProbeResults(c);
    }

    public static <S> ApiInterfaceWithoutResponse<S, PushCrawlerUMMessagesRequestVM, Void, Void> pushMessages(Class<S> source) {
        return stagingComputingGraph.pushMessages(source);
    }

    public static <S> ApiInterfaceWithResponse<S, CheckWhichUMArtefactsAreKnownRequestVM, CheckWhichUMArtefactsAreKnownResponseVM, Void> checkWhichArtefactsAreKnown(Class<S> source) {
        return stagingComputingGraph.checkWhichArtefactsAreKnown(source);
    }

    public static <S> ApiInterfaceWithOrWithoutResponse<S, PushDataRequestVM, PushCrawlerUMDataResponseVM, NoMoreMessages> pushData(Class<S> source) {
        return stagingComputingGraph.pushData(source);
    }

    public static <S> ApiInterfaceWithoutResponse<S, SetContextKeyRequest, Void, NoMoreData> sendContextKeyValues(Class<S> source) {
        return stagingComputingGraph.sendContextKeyValues(source);
    }

    private PluginInterface() {
    }

    static void cleanStagingHandlers(WaveSystem waveSystem, IngestionApiAsync ingestionApi, AgathaLogger agathaLogger, ObjectMapper objectMapper) {
        stagingComputingGraph = new RequestComputingGraph(waveSystem, ingestionApi, agathaLogger, objectMapper);
    }

    static void switchToStagingHandlers(WaveSystem waveSystem, IngestionApiAsync ingestionApi, AgathaLogger agathaLogger, ObjectMapper objectMapper) {
        currentComputingGraph = stagingComputingGraph;
        currentComputingGraph.buildComplete();
        PluginInterface.cleanStagingHandlers(waveSystem, ingestionApi, agathaLogger, objectMapper);
    }

    public static RequestComputingGraph getStagingComputingGraph() {
        return stagingComputingGraph;
    }

    public static RequestComputingGraph getCurrentComputingGraph() {
        return currentComputingGraph;
    }

    public static void setPluginId(String pluginId) {
        PluginInterface.pluginId = pluginId;
        if (stagingComputingGraph != null) {
            stagingComputingGraph.setPluginId(pluginId);
        }
        if (currentComputingGraph != null) {
            currentComputingGraph.setPluginId(pluginId);
        }
    }

    public static void setTrace(boolean newTrace) {
        trace = newTrace;
    }

    public static boolean isTrace() {
        return trace;
    }

    static {
        pluginId = "";
    }
}

