/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.wave.scripting.http;

import com.xebialabs.impact.api.CrawlerMessageWithCredentials;
import com.xebialabs.impact.wave.scripting.engine.ContextBase;
import com.xebialabs.impact.wave.scripting.engine.ReduceGroupBy;
import com.xebialabs.impact.wave.scripting.engine.ReducingHandler;
import com.xebialabs.impact.wave.scripting.http.ApiRouterFunction;
import com.xebialabs.impact.wave.scripting.http.RequestComputingGraph;
import com.xebialabs.impact.wave.scripting.http.WaveContext;
import com.xebialabs.impact.wave.scripting.http.signals.Finish;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction3;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiHandler<S, T, T1, E>
extends ReducingHandler<S, WaveContext> {
    private static final Logger logger = LoggerFactory.getLogger(ApiHandler.class);

    public ApiHandler(String name, Class<S> source, RequestComputingGraph computingGraph, Class<?> destination, CheckedFunction1<S, T> mapToRequestFn, CheckedFunction3<S, T1, ContextBase, Object> processResponseFn, ApiRouterFunction<T, T1, E> apiRouter, Class<E> enableSignal, Class<?> completedSignal) {
        Class[] classArray;
        if (enableSignal == Void.class) {
            classArray = new Class[]{};
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = enableSignal;
        }
        super(name, source, classArray, ApiHandler.makeDestinations(completedSignal, destination), new ReduceGroupBy[]{new ReduceGroupBy<CrawlerMessageWithCredentials>(CrawlerMessageWithCredentials.class, (CheckedFunction1 & Serializable)v -> v)}, stream -> {
            CompletableFuture<Object> enableSignalCame;
            ArrayList awaitingEnableSignal = new ArrayList();
            if (enableSignal == Void.class) {
                logger.info("No enable signal specified for [{}]", (Object)name);
                enableSignalCame = CompletableFuture.completedFuture(null);
            } else {
                logger.info("Enable signal [{}] specified for [{}], waiting for enable signal", (Object)enableSignal.getSimpleName(), (Object)name);
                enableSignalCame = new CompletableFuture();
                stream.get(enableSignal, (CheckedFunction1 & Serializable)signal -> {
                    if (enableSignalCame.isDone()) {
                        throw new IllegalStateException("Enable signal [" + enableSignal.getSimpleName() + "] came twice");
                    }
                    enableSignalCame.complete(signal);
                    return CompletableFuture.allOf(awaitingEnableSignal.toArray(new CompletableFuture[0]));
                });
            }
            stream.getWrapper(source, (CheckedFunction1 & Serializable)s -> {
                Object request = mapToRequestFn.apply(s.getObject());
                CompletionStage action = enableSignalCame.thenComposeAsync(signal -> {
                    CompletionStage apply = (CompletionStage)apiRouter.apply(request, (CrawlerMessageWithCredentials)stream.getBucket().get(0), signal);
                    s.saveIfNecessary(request, "request");
                    return apply.thenComposeAsync(response -> {
                        s.saveIfNecessary(response, "response");
                        if (processResponseFn != null) {
                            try {
                                Object result = processResponseFn.apply(s.getObject(), response, stream.ctx());
                                if (result instanceof CompletionStage) {
                                    return ((CompletionStage)result).toCompletableFuture();
                                }
                            }
                            catch (Throwable throwable) {
                                logger.error("Exception when handing [" + response.getClass().getSimpleName() + "]", throwable);
                                throw new IllegalStateException(throwable);
                            }
                        }
                        CompletableFuture<Object> completed = CompletableFuture.completedFuture(null);
                        return completed;
                    });
                });
                if (enableSignalCame.isDone()) {
                    return action;
                }
                awaitingEnableSignal.add(action.toCompletableFuture());
                return null;
            });
        }, computingGraph);
    }

    private static Class<?>[] makeDestinations(Class<?> completedSignal, Class<?> destination) {
        ArrayList destinations = new ArrayList();
        if (completedSignal != Void.class) {
            destinations.add(completedSignal);
        }
        if (destination != null) {
            destinations.add(destination);
        }
        if (destinations.isEmpty()) {
            destinations.add(Finish.class);
        }
        return destinations.toArray(new Class[0]);
    }
}

