import akka.http.javadsl.model.HttpRequest
import akka.http.javadsl.model.headers.HttpCredentials
import com.xebialabs.impact.api.DataSourceTypeEnum
import com.xebialabs.impact.wave.scripting.PluginInterface
import com.xebialabs.impact.wave.scripting.http.PushDataRequestVM
import com.xebialabs.impact.wave.scripting.um.UmModel

import java.util.stream.StreamSupport


class WorkspacesToCrawlFields {
    String id;
    String numericId
}

class CrawledFields {
    List<CrawledField> fields = new ArrayList<>()
    Map<String, CrawledField> fieldsById = new HashMap<>()
    Map<String, CrawledField> fieldsByDisplayName = new HashMap<>()
}

enum FieldType {
    STRING, MULTIVALUE
}

class CrawledField {
    String objectType;
    String refObjectName;
    String displayName;
    String elementName;
    String workspaceId
    String compositeDisplayName
    String compositeId
    FieldType fieldType
}

class CrawledFieldsOfWorkspace {
    List<CrawledField> fields = new ArrayList<>()
}

PluginInterface.map(CrawlFields).into(RequestCustomFieldsFromCache).via({crawlFields, ctx ->
    ctx.emit(new RequestCustomFieldsFromCache(true))
})

class RequestCustomFields {

}

PluginInterface.map(RequestCustomFieldsFromCache).into(RequestCustomFields, CachedCustomFields).via({request, ctx ->
    if (request.force || CustomFieldsLocalCache.crawledFields == null) {
        ctx.emit(new RequestCustomFields())
    } else {
        ctx.emit(new CachedCustomFields(CustomFieldsLocalCache.crawledFields))
    }
})

PluginInterface.request(RequestCustomFields).into(WorkspacesToCrawlFields)
        .mapToRequest({ unused, ctx ->
    def credentials = ctx.crawlerMessageWithCredentials.credentials
    def auth = credentials.credentials[0]
    HttpRequest.GET(credentials.endpoint + "webservice/v2.0/workspace")
            .addCredentials(HttpCredentials.createBasicHttpCredentials(
            auth.username,
            auth.password))
})
        .parseResponse({ unused, httpResponse, parser, ctx ->
    parser.readStringValueAndThen(".QueryResult.Results[]._ref", { ref ->
        def workspace = new WorkspacesToCrawlFields()
        workspace.id = workspace.numericId = ref.replaceAll('^.*\\/(\\d+)$', '$1')
        ctx.emit(workspace)
    })
})

PluginInterface.request(WorkspacesToCrawlFields).into(CrawledFieldsOfWorkspace, WorkspacesToCrawlFields)
        .mapToRequest({ workspace, ctx ->
    def credentials = ctx.crawlerMessageWithCredentials.credentials
    def auth = credentials.credentials[0]
    HttpRequest.GET(credentials.endpoint + "schema/v2.0/workspace/" + workspace.id)
            .addCredentials(HttpCredentials.createBasicHttpCredentials(
            auth.username,
            auth.password))
})
        .parseResponse({ workspace, httpResponse, parser, ctx ->
    if (httpResponse.status().isRedirection()) {
        def redirectedWorkspace = new WorkspacesToCrawlFields()
        redirectedWorkspace.numericId = workspace.numericId
        redirectedWorkspace.id = StreamSupport.stream(httpResponse.getHeaders().spliterator(), false)
                .filter({ h -> h.lowercaseName().equals("location") })
                .findFirst()
                .orElseThrow({ new IllegalArgumentException("Strange redirect without location header") })
                .value()
                .replaceAll('^.*\\/slm\\/schema\\/v2\\.0\\/workspace\\/', '')
        ctx.emit(redirectedWorkspace)
    } else {
        CrawledFieldsOfWorkspace crawledFieldsOfWorkspace = new CrawledFieldsOfWorkspace();
        parser.onObject(".QueryResult.Results[]", {
            List<CrawledField> fieldsOfThisType = new ArrayList<>()
            def type = parser.readValueInto("._refObjectName")
            parser.onObject(".Attributes[]", {
                CrawledField crawledField = new CrawledField();
                crawledField.workspaceId = workspace.numericId
                parser.readBoolValueAndThen(".Custom", {
                    if (it) {
                        fieldsOfThisType.add(crawledField)
                    }
                })
                parser.readStringValueAndThen(".AttributeType", {
                    crawledField.fieldType = it.equals("COLLECTION") ? FieldType.MULTIVALUE : FieldType.STRING
                })
                parser.readStringValueAndThen(".Name", { crawledField.displayName = it })
                parser.readStringValueAndThen("._refObjectName", { crawledField.refObjectName = it })
                parser.readStringValueAndThen(".ElementName", { crawledField.elementName = it })
            })
            parser.onFinish({
                fieldsOfThisType.forEach({
                    it.objectType = type.toString()
                    it.compositeDisplayName = it.workspaceId + "/" + it.objectType + "/" + it.displayName.toUpperCase()
                    it.compositeId = it.workspaceId + "/" + it.objectType + "/" + it.elementName
                })
                crawledFieldsOfWorkspace.fields.addAll(fieldsOfThisType)
            })
        })
        parser.onFinish({ ctx.emit(crawledFieldsOfWorkspace)})
    }
})

PluginInterface.reduce(CrawledFieldsOfWorkspace).into(PushDataPackage, CachedCustomFields)
        .via({ stream ->
    def fields = new CrawledFields()
    stream.get({ fieldsOfWorkspace ->
        fieldsOfWorkspace.fields.forEach({
            fields.fieldsByDisplayName.put(it.compositeDisplayName, it)
            fields.fieldsById.put(it.compositeId, it)
        })
        fields.fields.addAll(fieldsOfWorkspace.fields)
    })
    stream.onFinish({
        PushDataPackage pushDataPackage = new PushDataPackage()
        pushDataPackage.crawledFields = fields
        stream.emit(pushDataPackage)
        stream.emit(new CachedCustomFields(fields))
        CustomFieldsLocalCache.crawledFields = fields
    })
})

class FieldTitle {
    String displayName
}

enum FieldUmType {
    multiSelect, stringNotAnalyzed
}

class FieldUmModel {
    FieldUmType type
    FieldTitle title = new FieldTitle()
}

class FieldsUmModel extends UmModel {
    Map<String, FieldUmModel> fields = new HashMap<>();
}